/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingPlanResourcesRequest extends AutoScalingPlansRequest implements
        ToCopyableBuilder<DescribeScalingPlanResourcesRequest.Builder, DescribeScalingPlanResourcesRequest> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingPlanName").getter(getter(DescribeScalingPlanResourcesRequest::scalingPlanName))
            .setter(setter(Builder::scalingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()).build();

    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScalingPlanVersion").getter(getter(DescribeScalingPlanResourcesRequest::scalingPlanVersion))
            .setter(setter(Builder::scalingPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeScalingPlanResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalingPlanResourcesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD,
            SCALING_PLAN_VERSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String scalingPlanName;

    private final Long scalingPlanVersion;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeScalingPlanResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the scaling plan.
     * </p>
     * 
     * @return The name of the scaling plan.
     */
    public final String scalingPlanName() {
        return scalingPlanName;
    }

    /**
     * <p>
     * The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
     * </p>
     * 
     * @return The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
     */
    public final Long scalingPlanVersion() {
        return scalingPlanVersion;
    }

    /**
     * <p>
     * The maximum number of scalable resources to return. The value must be between 1 and 50. The default value is 50.
     * </p>
     * 
     * @return The maximum number of scalable resources to return. The value must be between 1 and 50. The default value
     *         is 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPlanResourcesRequest)) {
            return false;
        }
        DescribeScalingPlanResourcesRequest other = (DescribeScalingPlanResourcesRequest) obj;
        return Objects.equals(scalingPlanName(), other.scalingPlanName())
                && Objects.equals(scalingPlanVersion(), other.scalingPlanVersion())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScalingPlanResourcesRequest").add("ScalingPlanName", scalingPlanName())
                .add("ScalingPlanVersion", scalingPlanVersion()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanName":
            return Optional.ofNullable(clazz.cast(scalingPlanName()));
        case "ScalingPlanVersion":
            return Optional.ofNullable(clazz.cast(scalingPlanVersion()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPlanResourcesRequest, T> g) {
        return obj -> g.apply((DescribeScalingPlanResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingPlansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalingPlanResourcesRequest> {
        /**
         * <p>
         * The name of the scaling plan.
         * </p>
         * 
         * @param scalingPlanName
         *        The name of the scaling plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanName(String scalingPlanName);

        /**
         * <p>
         * The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
         * </p>
         * 
         * @param scalingPlanVersion
         *        The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanVersion(Long scalingPlanVersion);

        /**
         * <p>
         * The maximum number of scalable resources to return. The value must be between 1 and 50. The default value is
         * 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of scalable resources to return. The value must be between 1 and 50. The default
         *        value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingPlansRequest.BuilderImpl implements Builder {
        private String scalingPlanName;

        private Long scalingPlanVersion;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPlanResourcesRequest model) {
            super(model);
            scalingPlanName(model.scalingPlanName);
            scalingPlanVersion(model.scalingPlanVersion);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getScalingPlanName() {
            return scalingPlanName;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final Long getScalingPlanVersion() {
            return scalingPlanVersion;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingPlanResourcesRequest build() {
            return new DescribeScalingPlanResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
