/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansRequest;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingInstructionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScalingPlanRequest
extends AutoScalingPlansRequest
implements ToCopyableBuilder<Builder, CreateScalingPlanRequest> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingPlanName").getter(CreateScalingPlanRequest.getter(CreateScalingPlanRequest::scalingPlanName)).setter(CreateScalingPlanRequest.setter(Builder::scalingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()}).build();
    private static final SdkField<ApplicationSource> APPLICATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSource").getter(CreateScalingPlanRequest.getter(CreateScalingPlanRequest::applicationSource)).setter(CreateScalingPlanRequest.setter(Builder::applicationSource)).constructor(ApplicationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSource").build()}).build();
    private static final SdkField<List<ScalingInstruction>> SCALING_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingInstructions").getter(CreateScalingPlanRequest.getter(CreateScalingPlanRequest::scalingInstructions)).setter(CreateScalingPlanRequest.setter(Builder::scalingInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingInstructions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD, APPLICATION_SOURCE_FIELD, SCALING_INSTRUCTIONS_FIELD));
    private final String scalingPlanName;
    private final ApplicationSource applicationSource;
    private final List<ScalingInstruction> scalingInstructions;

    private CreateScalingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanName = builder.scalingPlanName;
        this.applicationSource = builder.applicationSource;
        this.scalingInstructions = builder.scalingInstructions;
    }

    public final String scalingPlanName() {
        return this.scalingPlanName;
    }

    public final ApplicationSource applicationSource() {
        return this.applicationSource;
    }

    public final boolean hasScalingInstructions() {
        return this.scalingInstructions != null && !(this.scalingInstructions instanceof SdkAutoConstructList);
    }

    public final List<ScalingInstruction> scalingInstructions() {
        return this.scalingInstructions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingInstructions() ? this.scalingInstructions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScalingPlanRequest)) {
            return false;
        }
        CreateScalingPlanRequest other = (CreateScalingPlanRequest)((Object)obj);
        return Objects.equals(this.scalingPlanName(), other.scalingPlanName()) && Objects.equals(this.applicationSource(), other.applicationSource()) && this.hasScalingInstructions() == other.hasScalingInstructions() && Objects.equals(this.scalingInstructions(), other.scalingInstructions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScalingPlanRequest").add("ScalingPlanName", (Object)this.scalingPlanName()).add("ApplicationSource", (Object)this.applicationSource()).add("ScalingInstructions", this.hasScalingInstructions() ? this.scalingInstructions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlanName": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanName()));
            }
            case "ApplicationSource": {
                return Optional.ofNullable(clazz.cast(this.applicationSource()));
            }
            case "ScalingInstructions": {
                return Optional.ofNullable(clazz.cast(this.scalingInstructions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScalingPlanRequest, T> g) {
        return obj -> g.apply((CreateScalingPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansRequest.BuilderImpl
    implements Builder {
        private String scalingPlanName;
        private ApplicationSource applicationSource;
        private List<ScalingInstruction> scalingInstructions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScalingPlanRequest model) {
            super(model);
            this.scalingPlanName(model.scalingPlanName);
            this.applicationSource(model.applicationSource);
            this.scalingInstructions(model.scalingInstructions);
        }

        public final String getScalingPlanName() {
            return this.scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        public final ApplicationSource.Builder getApplicationSource() {
            return this.applicationSource != null ? this.applicationSource.toBuilder() : null;
        }

        @Override
        public final Builder applicationSource(ApplicationSource applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        public final void setApplicationSource(ApplicationSource.BuilderImpl applicationSource) {
            this.applicationSource = applicationSource != null ? applicationSource.build() : null;
        }

        public final List<ScalingInstruction.Builder> getScalingInstructions() {
            List<ScalingInstruction.Builder> result = ScalingInstructionsCopier.copyToBuilder(this.scalingInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copy(scalingInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(ScalingInstruction ... scalingInstructions) {
            this.scalingInstructions(Arrays.asList(scalingInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(Consumer<ScalingInstruction.Builder> ... scalingInstructions) {
            this.scalingInstructions(Stream.of(scalingInstructions).map(c -> (ScalingInstruction)((ScalingInstruction.Builder)ScalingInstruction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingInstructions(Collection<ScalingInstruction.BuilderImpl> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copyFromBuilder(scalingInstructions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScalingPlanRequest build() {
            return new CreateScalingPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingPlansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScalingPlanRequest> {
        public Builder scalingPlanName(String var1);

        public Builder applicationSource(ApplicationSource var1);

        default public Builder applicationSource(Consumer<ApplicationSource.Builder> applicationSource) {
            return this.applicationSource((ApplicationSource)((ApplicationSource.Builder)ApplicationSource.builder().applyMutation(applicationSource)).build());
        }

        public Builder scalingInstructions(Collection<ScalingInstruction> var1);

        public Builder scalingInstructions(ScalingInstruction ... var1);

        public Builder scalingInstructions(Consumer<ScalingInstruction.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

