/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScalingPlanRequest extends AutoScalingPlansRequest implements
        ToCopyableBuilder<CreateScalingPlanRequest.Builder, CreateScalingPlanRequest> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateScalingPlanRequest::scalingPlanName)).setter(setter(Builder::scalingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()).build();

    private static final SdkField<ApplicationSource> APPLICATION_SOURCE_FIELD = SdkField
            .<ApplicationSource> builder(MarshallingType.SDK_POJO).getter(getter(CreateScalingPlanRequest::applicationSource))
            .setter(setter(Builder::applicationSource)).constructor(ApplicationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSource").build()).build();

    private static final SdkField<List<ScalingInstruction>> SCALING_INSTRUCTIONS_FIELD = SdkField
            .<List<ScalingInstruction>> builder(MarshallingType.LIST)
            .getter(getter(CreateScalingPlanRequest::scalingInstructions))
            .setter(setter(Builder::scalingInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingInstructions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingInstruction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingInstruction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD,
            APPLICATION_SOURCE_FIELD, SCALING_INSTRUCTIONS_FIELD));

    private final String scalingPlanName;

    private final ApplicationSource applicationSource;

    private final List<ScalingInstruction> scalingInstructions;

    private CreateScalingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanName = builder.scalingPlanName;
        this.applicationSource = builder.applicationSource;
        this.scalingInstructions = builder.scalingInstructions;
    }

    /**
     * <p>
     * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     * </p>
     * 
     * @return The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     */
    public String scalingPlanName() {
        return scalingPlanName;
    }

    /**
     * <p>
     * A CloudFormation stack or set of tags. You can create one scaling plan per application source.
     * </p>
     * 
     * @return A CloudFormation stack or set of tags. You can create one scaling plan per application source.
     */
    public ApplicationSource applicationSource() {
        return applicationSource;
    }

    /**
     * Returns true if the ScalingInstructions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasScalingInstructions() {
        return scalingInstructions != null && !(scalingInstructions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scaling instructions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScalingInstructions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The scaling instructions.
     */
    public List<ScalingInstruction> scalingInstructions() {
        return scalingInstructions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSource());
        hashCode = 31 * hashCode + Objects.hashCode(scalingInstructions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScalingPlanRequest)) {
            return false;
        }
        CreateScalingPlanRequest other = (CreateScalingPlanRequest) obj;
        return Objects.equals(scalingPlanName(), other.scalingPlanName())
                && Objects.equals(applicationSource(), other.applicationSource())
                && Objects.equals(scalingInstructions(), other.scalingInstructions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateScalingPlanRequest").add("ScalingPlanName", scalingPlanName())
                .add("ApplicationSource", applicationSource()).add("ScalingInstructions", scalingInstructions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanName":
            return Optional.ofNullable(clazz.cast(scalingPlanName()));
        case "ApplicationSource":
            return Optional.ofNullable(clazz.cast(applicationSource()));
        case "ScalingInstructions":
            return Optional.ofNullable(clazz.cast(scalingInstructions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScalingPlanRequest, T> g) {
        return obj -> g.apply((CreateScalingPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingPlansRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScalingPlanRequest> {
        /**
         * <p>
         * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
         * </p>
         * 
         * @param scalingPlanName
         *        The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanName(String scalingPlanName);

        /**
         * <p>
         * A CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * </p>
         * 
         * @param applicationSource
         *        A CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSource(ApplicationSource applicationSource);

        /**
         * <p>
         * A CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSource.Builder} avoiding the need to
         * create one manually via {@link ApplicationSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSource.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationSource(ApplicationSource)}.
         * 
         * @param applicationSource
         *        a consumer that will call methods on {@link ApplicationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSource(ApplicationSource)
         */
        default Builder applicationSource(Consumer<ApplicationSource.Builder> applicationSource) {
            return applicationSource(ApplicationSource.builder().applyMutation(applicationSource).build());
        }

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * 
         * @param scalingInstructions
         *        The scaling instructions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions);

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * 
         * @param scalingInstructions
         *        The scaling instructions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingInstructions(ScalingInstruction... scalingInstructions);

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScalingInstruction>.Builder} avoiding the
         * need to create one manually via {@link List<ScalingInstruction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScalingInstruction>.Builder#build()} is called immediately
         * and its result is passed to {@link #scalingInstructions(List<ScalingInstruction>)}.
         * 
         * @param scalingInstructions
         *        a consumer that will call methods on {@link List<ScalingInstruction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingInstructions(List<ScalingInstruction>)
         */
        Builder scalingInstructions(Consumer<ScalingInstruction.Builder>... scalingInstructions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingPlansRequest.BuilderImpl implements Builder {
        private String scalingPlanName;

        private ApplicationSource applicationSource;

        private List<ScalingInstruction> scalingInstructions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScalingPlanRequest model) {
            super(model);
            scalingPlanName(model.scalingPlanName);
            applicationSource(model.applicationSource);
            scalingInstructions(model.scalingInstructions);
        }

        public final String getScalingPlanName() {
            return scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        public final ApplicationSource.Builder getApplicationSource() {
            return applicationSource != null ? applicationSource.toBuilder() : null;
        }

        @Override
        public final Builder applicationSource(ApplicationSource applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        public final void setApplicationSource(ApplicationSource.BuilderImpl applicationSource) {
            this.applicationSource = applicationSource != null ? applicationSource.build() : null;
        }

        public final Collection<ScalingInstruction.Builder> getScalingInstructions() {
            return scalingInstructions != null ? scalingInstructions.stream().map(ScalingInstruction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copy(scalingInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(ScalingInstruction... scalingInstructions) {
            scalingInstructions(Arrays.asList(scalingInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(Consumer<ScalingInstruction.Builder>... scalingInstructions) {
            scalingInstructions(Stream.of(scalingInstructions).map(c -> ScalingInstruction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScalingInstructions(Collection<ScalingInstruction.BuilderImpl> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copyFromBuilder(scalingInstructions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScalingPlanRequest build() {
            return new CreateScalingPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
