/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an application source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSource implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSource.Builder, ApplicationSource> {
    private static final SdkField<String> CLOUD_FORMATION_STACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationSource::cloudFormationStackARN)).setter(setter(Builder::cloudFormationStackARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormationStackARN").build())
            .build();

    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .getter(getter(ApplicationSource::tagFilters))
            .setter(setter(Builder::tagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_FORMATION_STACK_ARN_FIELD, TAG_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudFormationStackARN;

    private final List<TagFilter> tagFilters;

    private ApplicationSource(BuilderImpl builder) {
        this.cloudFormationStackARN = builder.cloudFormationStackARN;
        this.tagFilters = builder.tagFilters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a AWS CloudFormation stack.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a AWS CloudFormation stack.
     */
    public String cloudFormationStackARN() {
        return cloudFormationStackARN;
    }

    /**
     * Returns true if the TagFilters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagFilters() {
        return tagFilters != null && !(tagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags (up to 50).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of tags (up to 50).
     */
    public List<TagFilter> tagFilters() {
        return tagFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationStackARN());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSource)) {
            return false;
        }
        ApplicationSource other = (ApplicationSource) obj;
        return Objects.equals(cloudFormationStackARN(), other.cloudFormationStackARN())
                && Objects.equals(tagFilters(), other.tagFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationSource").add("CloudFormationStackARN", cloudFormationStackARN())
                .add("TagFilters", tagFilters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFormationStackARN":
            return Optional.ofNullable(clazz.cast(cloudFormationStackARN()));
        case "TagFilters":
            return Optional.ofNullable(clazz.cast(tagFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSource, T> g) {
        return obj -> g.apply((ApplicationSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSource> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a AWS CloudFormation stack.
         * </p>
         * 
         * @param cloudFormationStackARN
         *        The Amazon Resource Name (ARN) of a AWS CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationStackARN(String cloudFormationStackARN);

        /**
         * <p>
         * A set of tags (up to 50).
         * </p>
         * 
         * @param tagFilters
         *        A set of tags (up to 50).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<TagFilter> tagFilters);

        /**
         * <p>
         * A set of tags (up to 50).
         * </p>
         * 
         * @param tagFilters
         *        A set of tags (up to 50).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(TagFilter... tagFilters);

        /**
         * <p>
         * A set of tags (up to 50).
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagFilter>.Builder} avoiding the need to
         * create one manually via {@link List<TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #tagFilters(List<TagFilter>)}.
         * 
         * @param tagFilters
         *        a consumer that will call methods on {@link List<TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilters(List<TagFilter>)
         */
        Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters);
    }

    static final class BuilderImpl implements Builder {
        private String cloudFormationStackARN;

        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSource model) {
            cloudFormationStackARN(model.cloudFormationStackARN);
            tagFilters(model.tagFilters);
        }

        public final String getCloudFormationStackARN() {
            return cloudFormationStackARN;
        }

        @Override
        public final Builder cloudFormationStackARN(String cloudFormationStackARN) {
            this.cloudFormationStackARN = cloudFormationStackARN;
            return this;
        }

        public final void setCloudFormationStackARN(String cloudFormationStackARN) {
            this.cloudFormationStackARN = cloudFormationStackARN;
        }

        public final Collection<TagFilter.Builder> getTagFilters() {
            return tagFilters != null ? tagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFiltersCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter... tagFilters) {
            tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters) {
            tagFilters(Stream.of(tagFilters).map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFiltersCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public ApplicationSource build() {
            return new ApplicationSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
