/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.ServiceLinkedRoleFailureException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.autoscaling.transform.AttachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchDeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchPutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CompleteLifecycleActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateOrUpdateTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAdjustmentTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingNotificationTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLaunchConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHookTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHooksRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeMetricCollectionTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeNotificationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribePoliciesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingProcessTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTerminationPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DisableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnterStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExecutePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExitStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.RecordLifecycleActionHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ResumeProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetDesiredCapacityRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceProtectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.UpdateAutoScalingGroupRequestMarshaller;

@SdkInternalApi
final class DefaultAutoScalingClient
implements AutoScalingClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAutoScalingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "autoscaling";
    }

    @Override
    public AttachInstancesResponse attachInstances(AttachInstancesRequest attachInstancesRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AttachInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachInstancesRequest).withMarshaller((Marshaller)new AttachInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AttachLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancerTargetGroupsRequest).withMarshaller((Marshaller)new AttachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AttachLoadBalancersResponse attachLoadBalancers(AttachLoadBalancersRequest attachLoadBalancersRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AttachLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancersRequest).withMarshaller((Marshaller)new AttachLoadBalancersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchDeleteScheduledActionResponse batchDeleteScheduledAction(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteScheduledActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (BatchDeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteScheduledAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteScheduledActionRequest).withMarshaller((Marshaller)new BatchDeleteScheduledActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchPutScheduledUpdateGroupActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (BatchPutScheduledUpdateGroupActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutScheduledUpdateGroupAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchPutScheduledUpdateGroupActionRequest).withMarshaller((Marshaller)new BatchPutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CompleteLifecycleActionResponse completeLifecycleAction(CompleteLifecycleActionRequest completeLifecycleActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CompleteLifecycleActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CompleteLifecycleActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLifecycleAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeLifecycleActionRequest).withMarshaller((Marshaller)new CompleteLifecycleActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateAutoScalingGroupResponse createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAutoScalingGroupRequest).withMarshaller((Marshaller)new CreateAutoScalingGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLaunchConfigurationResponse createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLaunchConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLaunchConfigurationRequest).withMarshaller((Marshaller)new CreateLaunchConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateOrUpdateTagsResponse createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) throws LimitExceededException, AlreadyExistsException, ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateOrUpdateTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateOrUpdateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrUpdateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrUpdateTagsRequest).withMarshaller((Marshaller)new CreateOrUpdateTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteAutoScalingGroupResponse deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAutoScalingGroupRequest).withMarshaller((Marshaller)new DeleteAutoScalingGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLaunchConfigurationResponse deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLaunchConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLaunchConfigurationRequest).withMarshaller((Marshaller)new DeleteLaunchConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLifecycleHookResponse deleteLifecycleHook(DeleteLifecycleHookRequest deleteLifecycleHookRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLifecycleHookResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteLifecycleHookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLifecycleHook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLifecycleHookRequest).withMarshaller((Marshaller)new DeleteLifecycleHookRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteNotificationConfigurationResponse deleteNotificationConfiguration(DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteNotificationConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNotificationConfigurationRequest).withMarshaller((Marshaller)new DeleteNotificationConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteScheduledActionResponse deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteScheduledActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScheduledActionRequest).withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAdjustmentTypesResponse describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAdjustmentTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAdjustmentTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAdjustmentTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAdjustmentTypesRequest).withMarshaller((Marshaller)new DescribeAdjustmentTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAutoScalingGroupsResponse describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAutoScalingGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingGroupsRequest).withMarshaller((Marshaller)new DescribeAutoScalingGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAutoScalingGroupsIterable describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeAutoScalingGroupsIterable(this, this.applyPaginatorUserAgent(describeAutoScalingGroupsRequest));
    }

    @Override
    public DescribeAutoScalingInstancesResponse describeAutoScalingInstances(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAutoScalingInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingInstancesRequest).withMarshaller((Marshaller)new DescribeAutoScalingInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAutoScalingInstancesIterable describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeAutoScalingInstancesIterable(this, this.applyPaginatorUserAgent(describeAutoScalingInstancesRequest));
    }

    @Override
    public DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingNotificationTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAutoScalingNotificationTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingNotificationTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingNotificationTypesRequest).withMarshaller((Marshaller)new DescribeAutoScalingNotificationTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLaunchConfigurationsResponse describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLaunchConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLaunchConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLaunchConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLaunchConfigurationsRequest).withMarshaller((Marshaller)new DescribeLaunchConfigurationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLaunchConfigurationsIterable describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeLaunchConfigurationsIterable(this, this.applyPaginatorUserAgent(describeLaunchConfigurationsRequest));
    }

    @Override
    public DescribeLifecycleHookTypesResponse describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHookTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLifecycleHookTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHookTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleHookTypesRequest).withMarshaller((Marshaller)new DescribeLifecycleHookTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLifecycleHooksResponse describeLifecycleHooks(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHooksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLifecycleHooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHooks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleHooksRequest).withMarshaller((Marshaller)new DescribeLifecycleHooksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerTargetGroupsRequest).withMarshaller((Marshaller)new DescribeLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeMetricCollectionTypesResponse describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeMetricCollectionTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeMetricCollectionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricCollectionTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMetricCollectionTypesRequest).withMarshaller((Marshaller)new DescribeMetricCollectionTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeNotificationConfigurationsResponse describeNotificationConfigurations(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNotificationConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeNotificationConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNotificationConfigurationsRequest).withMarshaller((Marshaller)new DescribeNotificationConfigurationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeNotificationConfigurationsIterable describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeNotificationConfigurationsIterable(this, this.applyPaginatorUserAgent(describeNotificationConfigurationsRequest));
    }

    @Override
    public DescribePoliciesResponse describePolicies(DescribePoliciesRequest describePoliciesRequest) throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePoliciesRequest).withMarshaller((Marshaller)new DescribePoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribePoliciesIterable describePoliciesPaginator(DescribePoliciesRequest describePoliciesRequest) throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribePoliciesIterable(this, this.applyPaginatorUserAgent(describePoliciesRequest));
    }

    @Override
    public DescribeScalingActivitiesResponse describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingActivitiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeScalingActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingActivities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingActivitiesRequest).withMarshaller((Marshaller)new DescribeScalingActivitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeScalingActivitiesIterable describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeScalingActivitiesIterable(this, this.applyPaginatorUserAgent(describeScalingActivitiesRequest));
    }

    @Override
    public DescribeScalingProcessTypesResponse describeScalingProcessTypes(DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingProcessTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeScalingProcessTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingProcessTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingProcessTypesRequest).withMarshaller((Marshaller)new DescribeScalingProcessTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeScheduledActionsResponse describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScheduledActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeScheduledActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScheduledActionsRequest).withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeScheduledActionsIterable describeScheduledActionsPaginator(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeScheduledActionsIterable(this, this.applyPaginatorUserAgent(describeScheduledActionsRequest));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTagsIterable describeTagsPaginator(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeTagsIterable(this, this.applyPaginatorUserAgent(describeTagsRequest));
    }

    @Override
    public DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTerminationPolicyTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTerminationPolicyTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTerminationPolicyTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTerminationPolicyTypesRequest).withMarshaller((Marshaller)new DescribeTerminationPolicyTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetachInstancesResponse detachInstances(DetachInstancesRequest detachInstancesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetachInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachInstancesRequest).withMarshaller((Marshaller)new DetachInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetachLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancerTargetGroupsRequest).withMarshaller((Marshaller)new DetachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetachLoadBalancersResponse detachLoadBalancers(DetachLoadBalancersRequest detachLoadBalancersRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetachLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancersRequest).withMarshaller((Marshaller)new DetachLoadBalancersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableMetricsCollectionResponse disableMetricsCollection(DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableMetricsCollectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DisableMetricsCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableMetricsCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableMetricsCollectionRequest).withMarshaller((Marshaller)new DisableMetricsCollectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableMetricsCollectionResponse enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableMetricsCollectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EnableMetricsCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableMetricsCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableMetricsCollectionRequest).withMarshaller((Marshaller)new EnableMetricsCollectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnterStandbyResponse enterStandby(EnterStandbyRequest enterStandbyRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnterStandbyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EnterStandbyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnterStandby").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enterStandbyRequest).withMarshaller((Marshaller)new EnterStandbyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ExecutePolicyResponse executePolicy(ExecutePolicyRequest executePolicyRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExecutePolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ExecutePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecutePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executePolicyRequest).withMarshaller((Marshaller)new ExecutePolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ExitStandbyResponse exitStandby(ExitStandbyRequest exitStandbyRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExitStandbyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ExitStandbyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExitStandby").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exitStandbyRequest).withMarshaller((Marshaller)new ExitStandbyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutLifecycleHookResponse putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutLifecycleHookResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutLifecycleHookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLifecycleHook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLifecycleHookRequest).withMarshaller((Marshaller)new PutLifecycleHookRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutNotificationConfigurationResponse putNotificationConfiguration(PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutNotificationConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putNotificationConfigurationRequest).withMarshaller((Marshaller)new PutNotificationConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScalingPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScalingPolicyRequest).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScheduledUpdateGroupActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutScheduledUpdateGroupActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScheduledUpdateGroupAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScheduledUpdateGroupActionRequest).withMarshaller((Marshaller)new PutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RecordLifecycleActionHeartbeatResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RecordLifecycleActionHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordLifecycleActionHeartbeat").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recordLifecycleActionHeartbeatRequest).withMarshaller((Marshaller)new RecordLifecycleActionHeartbeatRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResumeProcessesResponse resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResumeProcessesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResumeProcessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeProcesses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeProcessesRequest).withMarshaller((Marshaller)new ResumeProcessesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetDesiredCapacityResponse setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetDesiredCapacityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetDesiredCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDesiredCapacity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setDesiredCapacityRequest).withMarshaller((Marshaller)new SetDesiredCapacityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetInstanceHealthResponse setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetInstanceHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setInstanceHealthRequest).withMarshaller((Marshaller)new SetInstanceHealthRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetInstanceProtectionResponse setInstanceProtection(SetInstanceProtectionRequest setInstanceProtectionRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceProtectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetInstanceProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceProtection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setInstanceProtectionRequest).withMarshaller((Marshaller)new SetInstanceProtectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SuspendProcessesResponse suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SuspendProcessesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SuspendProcessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SuspendProcesses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)suspendProcessesRequest).withMarshaller((Marshaller)new SuspendProcessesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TerminateInstanceInAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TerminateInstanceInAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateInstanceInAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateInstanceInAutoScalingGroupRequest).withMarshaller((Marshaller)new TerminateInstanceInAutoScalingGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateAutoScalingGroupResponse updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAutoScalingGroupRequest).withMarshaller((Marshaller)new UpdateAutoScalingGroupRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScalingActivityInProgress").exceptionBuilderSupplier(ScalingActivityInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextToken").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExists").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceContention").exceptionBuilderSupplier(ResourceContentionException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleFailure").exceptionBuilderSupplier(ServiceLinkedRoleFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AutoScalingException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AutoScalingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.9.24").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AutoScalingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

