/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutScheduledUpdateGroupActionRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, BatchPutScheduledUpdateGroupActionRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPutScheduledUpdateGroupActionRequest.getter(BatchPutScheduledUpdateGroupActionRequest::autoScalingGroupName)).setter(BatchPutScheduledUpdateGroupActionRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<ScheduledUpdateGroupActionRequest>> SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchPutScheduledUpdateGroupActionRequest.getter(BatchPutScheduledUpdateGroupActionRequest::scheduledUpdateGroupActions)).setter(BatchPutScheduledUpdateGroupActionRequest.setter(Builder::scheduledUpdateGroupActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateGroupActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledUpdateGroupActionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD));
    private final String autoScalingGroupName;
    private final List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions;

    private BatchPutScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledUpdateGroupActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutScheduledUpdateGroupActionRequest)) {
            return false;
        }
        BatchPutScheduledUpdateGroupActionRequest other = (BatchPutScheduledUpdateGroupActionRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.scheduledUpdateGroupActions(), other.scheduledUpdateGroupActions());
    }

    public String toString() {
        return ToString.builder((String)"BatchPutScheduledUpdateGroupActionRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScheduledUpdateGroupActions", this.scheduledUpdateGroupActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScheduledUpdateGroupActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledUpdateGroupActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutScheduledUpdateGroupActionRequest, T> g) {
        return obj -> g.apply((BatchPutScheduledUpdateGroupActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutScheduledUpdateGroupActionRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<ScheduledUpdateGroupActionRequest.Builder> getScheduledUpdateGroupActions() {
            return this.scheduledUpdateGroupActions != null ? (Collection)this.scheduledUpdateGroupActions.stream().map(ScheduledUpdateGroupActionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionRequestsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupActionRequest ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupActionRequest.Builder> ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Stream.of(scheduledUpdateGroupActions).map(c -> (ScheduledUpdateGroupActionRequest)((ScheduledUpdateGroupActionRequest.Builder)ScheduledUpdateGroupActionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledUpdateGroupActions(Collection<ScheduledUpdateGroupActionRequest.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionRequestsCopier.copyFromBuilder(scheduledUpdateGroupActions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutScheduledUpdateGroupActionRequest build() {
            return new BatchPutScheduledUpdateGroupActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutScheduledUpdateGroupActionRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupActionRequest> var1);

        public Builder scheduledUpdateGroupActions(ScheduledUpdateGroupActionRequest ... var1);

        public Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupActionRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

