/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstancesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoScalingInstancesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
    private static final SdkField<List<AutoScalingInstanceDetails>> AUTO_SCALING_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAutoScalingInstancesResponse.getter(DescribeAutoScalingInstancesResponse::autoScalingInstances)).setter(DescribeAutoScalingInstancesResponse.setter(Builder::autoScalingInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingInstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAutoScalingInstancesResponse.getter(DescribeAutoScalingInstancesResponse::nextToken)).setter(DescribeAutoScalingInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AutoScalingInstanceDetails> autoScalingInstances;
    private final String nextToken;

    private DescribeAutoScalingInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingInstances = builder.autoScalingInstances;
        this.nextToken = builder.nextToken;
    }

    public List<AutoScalingInstanceDetails> autoScalingInstances() {
        return this.autoScalingInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingInstancesResponse)) {
            return false;
        }
        DescribeAutoScalingInstancesResponse other = (DescribeAutoScalingInstancesResponse)((Object)obj);
        return Objects.equals(this.autoScalingInstances(), other.autoScalingInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAutoScalingInstancesResponse").add("AutoScalingInstances", this.autoScalingInstances()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingInstances": {
                return Optional.ofNullable(clazz.cast(this.autoScalingInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoScalingInstancesResponse, T> g) {
        return obj -> g.apply((DescribeAutoScalingInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<AutoScalingInstanceDetails> autoScalingInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingInstancesResponse model) {
            super(model);
            this.autoScalingInstances(model.autoScalingInstances);
            this.nextToken(model.nextToken);
        }

        public final Collection<AutoScalingInstanceDetails.Builder> getAutoScalingInstances() {
            return this.autoScalingInstances != null ? (Collection)this.autoScalingInstances.stream().map(AutoScalingInstanceDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copy(autoScalingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingInstances(AutoScalingInstanceDetails ... autoScalingInstances) {
            this.autoScalingInstances(Arrays.asList(autoScalingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingInstances(Consumer<AutoScalingInstanceDetails.Builder> ... autoScalingInstances) {
            this.autoScalingInstances(Stream.of(autoScalingInstances).map(c -> (AutoScalingInstanceDetails)((AutoScalingInstanceDetails.Builder)AutoScalingInstanceDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingInstances(Collection<AutoScalingInstanceDetails.BuilderImpl> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copyFromBuilder(autoScalingInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutoScalingInstancesResponse build() {
            return new DescribeAutoScalingInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
        public Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> var1);

        public Builder autoScalingInstances(AutoScalingInstanceDetails ... var1);

        public Builder autoScalingInstances(Consumer<AutoScalingInstanceDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

