/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the specific triggers that cause instances to be retained in a Retained state rather than terminated. Each
 * trigger corresponds to a different failure scenario during the instance lifecycle. This allows fine-grained control
 * over when to preserve instances for manual intervention.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionTriggers implements SdkPojo, Serializable,
        ToCopyableBuilder<RetentionTriggers.Builder, RetentionTriggers> {
    private static final SdkField<String> TERMINATE_HOOK_ABANDON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TerminateHookAbandon").getter(getter(RetentionTriggers::terminateHookAbandonAsString))
            .setter(setter(Builder::terminateHookAbandon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateHookAbandon").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATE_HOOK_ABANDON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String terminateHookAbandon;

    private RetentionTriggers(BuilderImpl builder) {
        this.terminateHookAbandon = builder.terminateHookAbandon;
    }

    /**
     * <p>
     * Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or explicit
     * abandonment (calling CompleteLifecycleAction).
     * </p>
     * <p>
     * Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to <code>Terminate</code> for
     * default termination behavior.
     * </p>
     * <p>
     * Retained instances don't count toward desired capacity and remain until you call
     * <code>TerminateInstanceInAutoScalingGroup</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #terminateHookAbandon} will return {@link RetentionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #terminateHookAbandonAsString}.
     * </p>
     * 
     * @return Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or explicit
     *         abandonment (calling CompleteLifecycleAction). </p>
     *         <p>
     *         Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to
     *         <code>Terminate</code> for default termination behavior.
     *         </p>
     *         <p>
     *         Retained instances don't count toward desired capacity and remain until you call
     *         <code>TerminateInstanceInAutoScalingGroup</code>.
     * @see RetentionAction
     */
    public final RetentionAction terminateHookAbandon() {
        return RetentionAction.fromValue(terminateHookAbandon);
    }

    /**
     * <p>
     * Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or explicit
     * abandonment (calling CompleteLifecycleAction).
     * </p>
     * <p>
     * Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to <code>Terminate</code> for
     * default termination behavior.
     * </p>
     * <p>
     * Retained instances don't count toward desired capacity and remain until you call
     * <code>TerminateInstanceInAutoScalingGroup</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #terminateHookAbandon} will return {@link RetentionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #terminateHookAbandonAsString}.
     * </p>
     * 
     * @return Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or explicit
     *         abandonment (calling CompleteLifecycleAction). </p>
     *         <p>
     *         Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to
     *         <code>Terminate</code> for default termination behavior.
     *         </p>
     *         <p>
     *         Retained instances don't count toward desired capacity and remain until you call
     *         <code>TerminateInstanceInAutoScalingGroup</code>.
     * @see RetentionAction
     */
    public final String terminateHookAbandonAsString() {
        return terminateHookAbandon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminateHookAbandonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionTriggers)) {
            return false;
        }
        RetentionTriggers other = (RetentionTriggers) obj;
        return Objects.equals(terminateHookAbandonAsString(), other.terminateHookAbandonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionTriggers").add("TerminateHookAbandon", terminateHookAbandonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminateHookAbandon":
            return Optional.ofNullable(clazz.cast(terminateHookAbandonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TerminateHookAbandon", TERMINATE_HOOK_ABANDON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetentionTriggers, T> g) {
        return obj -> g.apply((RetentionTriggers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionTriggers> {
        /**
         * <p>
         * Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or explicit
         * abandonment (calling CompleteLifecycleAction).
         * </p>
         * <p>
         * Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to <code>Terminate</code>
         * for default termination behavior.
         * </p>
         * <p>
         * Retained instances don't count toward desired capacity and remain until you call
         * <code>TerminateInstanceInAutoScalingGroup</code>.
         * </p>
         * 
         * @param terminateHookAbandon
         *        Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or
         *        explicit abandonment (calling CompleteLifecycleAction). </p>
         *        <p>
         *        Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to
         *        <code>Terminate</code> for default termination behavior.
         *        </p>
         *        <p>
         *        Retained instances don't count toward desired capacity and remain until you call
         *        <code>TerminateInstanceInAutoScalingGroup</code>.
         * @see RetentionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionAction
         */
        Builder terminateHookAbandon(String terminateHookAbandon);

        /**
         * <p>
         * Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or explicit
         * abandonment (calling CompleteLifecycleAction).
         * </p>
         * <p>
         * Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to <code>Terminate</code>
         * for default termination behavior.
         * </p>
         * <p>
         * Retained instances don't count toward desired capacity and remain until you call
         * <code>TerminateInstanceInAutoScalingGroup</code>.
         * </p>
         * 
         * @param terminateHookAbandon
         *        Specifies the action when a termination lifecycle hook is abandoned due to failure, timeout, or
         *        explicit abandonment (calling CompleteLifecycleAction). </p>
         *        <p>
         *        Set to <code>Retain</code> to move instances to a <code>Retained</code> state. Set to
         *        <code>Terminate</code> for default termination behavior.
         *        </p>
         *        <p>
         *        Retained instances don't count toward desired capacity and remain until you call
         *        <code>TerminateInstanceInAutoScalingGroup</code>.
         * @see RetentionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionAction
         */
        Builder terminateHookAbandon(RetentionAction terminateHookAbandon);
    }

    static final class BuilderImpl implements Builder {
        private String terminateHookAbandon;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionTriggers model) {
            terminateHookAbandon(model.terminateHookAbandon);
        }

        public final String getTerminateHookAbandon() {
            return terminateHookAbandon;
        }

        public final void setTerminateHookAbandon(String terminateHookAbandon) {
            this.terminateHookAbandon = terminateHookAbandon;
        }

        @Override
        public final Builder terminateHookAbandon(String terminateHookAbandon) {
            this.terminateHookAbandon = terminateHookAbandon;
            return this;
        }

        @Override
        public final Builder terminateHookAbandon(RetentionAction terminateHookAbandon) {
            this.terminateHookAbandon(terminateHookAbandon == null ? null : terminateHookAbandon.toString());
            return this;
        }

        @Override
        public RetentionTriggers build() {
            return new RetentionTriggers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
