/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutePolicyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<ExecutePolicyRequest.Builder, ExecutePolicyRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(ExecutePolicyRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(ExecutePolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<Boolean> HONOR_COOLDOWN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HonorCooldown").getter(getter(ExecutePolicyRequest::honorCooldown))
            .setter(setter(Builder::honorCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorCooldown").build()).build();

    private static final SdkField<Double> METRIC_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MetricValue").getter(getter(ExecutePolicyRequest::metricValue)).setter(setter(Builder::metricValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValue").build()).build();

    private static final SdkField<Double> BREACH_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BreachThreshold").getter(getter(ExecutePolicyRequest::breachThreshold))
            .setter(setter(Builder::breachThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreachThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            POLICY_NAME_FIELD, HONOR_COOLDOWN_FIELD, METRIC_VALUE_FIELD, BREACH_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String autoScalingGroupName;

    private final String policyName;

    private final Boolean honorCooldown;

    private final Double metricValue;

    private final Double breachThreshold;

    private ExecutePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.honorCooldown = builder.honorCooldown;
        this.metricValue = builder.metricValue;
        this.breachThreshold = builder.breachThreshold;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name or ARN of the policy.
     * </p>
     * 
     * @return The name or ARN of the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.
     * </p>
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html">Scaling
     * cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the
     *         policy.</p>
     *         <p>
     *         Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html"
     *         >Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean honorCooldown() {
        return honorCooldown;
    }

    /**
     * <p>
     * The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
     * <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50
     * and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric
     * value to 59.
     * </p>
     * <p>
     * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an
     * error.
     * </p>
     * <p>
     * Required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
     *         <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold
     *         is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set
     *         the metric value to 59.</p>
     *         <p>
     *         If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call
     *         returns an error.
     *         </p>
     *         <p>
     *         Required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public final Double metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The breach threshold for the alarm.
     * </p>
     * <p>
     * Required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The breach threshold for the alarm.</p>
     *         <p>
     *         Required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public final Double breachThreshold() {
        return breachThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(honorCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(breachThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutePolicyRequest)) {
            return false;
        }
        ExecutePolicyRequest other = (ExecutePolicyRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(honorCooldown(), other.honorCooldown())
                && Objects.equals(metricValue(), other.metricValue())
                && Objects.equals(breachThreshold(), other.breachThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutePolicyRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyName", policyName()).add("HonorCooldown", honorCooldown()).add("MetricValue", metricValue())
                .add("BreachThreshold", breachThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "HonorCooldown":
            return Optional.ofNullable(clazz.cast(honorCooldown()));
        case "MetricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "BreachThreshold":
            return Optional.ofNullable(clazz.cast(breachThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("HonorCooldown", HONOR_COOLDOWN_FIELD);
        map.put("MetricValue", METRIC_VALUE_FIELD);
        map.put("BreachThreshold", BREACH_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutePolicyRequest, T> g) {
        return obj -> g.apply((ExecutePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecutePolicyRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name or ARN of the policy.
         * </p>
         * 
         * @param policyName
         *        The name or ARN of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the
         * policy.
         * </p>
         * <p>
         * Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html">Scaling
         * cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param honorCooldown
         *        Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing
         *        the policy.</p>
         *        <p>
         *        Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html"
         *        >Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorCooldown(Boolean honorCooldown);

        /**
         * <p>
         * The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
         * <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is
         * 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the
         * metric value to 59.
         * </p>
         * <p>
         * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns
         * an error.
         * </p>
         * <p>
         * Required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param metricValue
         *        The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of
         *        type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach
         *        threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of
         *        10, you can set the metric value to 59.</p>
         *        <p>
         *        If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call
         *        returns an error.
         *        </p>
         *        <p>
         *        Required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(Double metricValue);

        /**
         * <p>
         * The breach threshold for the alarm.
         * </p>
         * <p>
         * Required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param breachThreshold
         *        The breach threshold for the alarm.</p>
         *        <p>
         *        Required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breachThreshold(Double breachThreshold);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private Boolean honorCooldown;

        private Double metricValue;

        private Double breachThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutePolicyRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            honorCooldown(model.honorCooldown);
            metricValue(model.metricValue);
            breachThreshold(model.breachThreshold);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Boolean getHonorCooldown() {
            return honorCooldown;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final Double getMetricValue() {
            return metricValue;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final Double getBreachThreshold() {
            return breachThreshold;
        }

        public final void setBreachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
        }

        @Override
        public final Builder breachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
