/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTerminationPolicyTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
    private static final SdkField<List<String>> TERMINATION_POLICY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminationPolicyTypes").getter(DescribeTerminationPolicyTypesResponse.getter(DescribeTerminationPolicyTypesResponse::terminationPolicyTypes)).setter(DescribeTerminationPolicyTypesResponse.setter(Builder::terminationPolicyTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicyTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATION_POLICY_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTerminationPolicyTypesResponse.memberNameToFieldInitializer();
    private final List<String> terminationPolicyTypes;

    private DescribeTerminationPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.terminationPolicyTypes = builder.terminationPolicyTypes;
    }

    public final boolean hasTerminationPolicyTypes() {
        return this.terminationPolicyTypes != null && !(this.terminationPolicyTypes instanceof SdkAutoConstructList);
    }

    public final List<String> terminationPolicyTypes() {
        return this.terminationPolicyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminationPolicyTypes() ? this.terminationPolicyTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTerminationPolicyTypesResponse)) {
            return false;
        }
        DescribeTerminationPolicyTypesResponse other = (DescribeTerminationPolicyTypesResponse)((Object)obj);
        return this.hasTerminationPolicyTypes() == other.hasTerminationPolicyTypes() && Objects.equals(this.terminationPolicyTypes(), other.terminationPolicyTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTerminationPolicyTypesResponse").add("TerminationPolicyTypes", this.hasTerminationPolicyTypes() ? this.terminationPolicyTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminationPolicyTypes": {
                return Optional.ofNullable(clazz.cast(this.terminationPolicyTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("TerminationPolicyTypes", TERMINATION_POLICY_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTerminationPolicyTypesResponse, T> g) {
        return obj -> g.apply((DescribeTerminationPolicyTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<String> terminationPolicyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTerminationPolicyTypesResponse model) {
            super(model);
            this.terminationPolicyTypes(model.terminationPolicyTypes);
        }

        public final Collection<String> getTerminationPolicyTypes() {
            if (this.terminationPolicyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terminationPolicyTypes;
        }

        public final void setTerminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
        }

        @Override
        public final Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicyTypes(String ... terminationPolicyTypes) {
            this.terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
            return this;
        }

        @Override
        public DescribeTerminationPolicyTypesResponse build() {
            return new DescribeTerminationPolicyTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
        public Builder terminationPolicyTypes(Collection<String> var1);

        public Builder terminationPolicyTypes(String ... var1);
    }
}

