/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshLivePoolProgress;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshWarmPoolProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRefreshProgressDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRefreshProgressDetails> {
    private static final SdkField<InstanceRefreshLivePoolProgress> LIVE_POOL_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LivePoolProgress").getter(InstanceRefreshProgressDetails.getter(InstanceRefreshProgressDetails::livePoolProgress)).setter(InstanceRefreshProgressDetails.setter(Builder::livePoolProgress)).constructor(InstanceRefreshLivePoolProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LivePoolProgress").build()}).build();
    private static final SdkField<InstanceRefreshWarmPoolProgress> WARM_POOL_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmPoolProgress").getter(InstanceRefreshProgressDetails.getter(InstanceRefreshProgressDetails::warmPoolProgress)).setter(InstanceRefreshProgressDetails.setter(Builder::warmPoolProgress)).constructor(InstanceRefreshWarmPoolProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolProgress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_POOL_PROGRESS_FIELD, WARM_POOL_PROGRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceRefreshProgressDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InstanceRefreshLivePoolProgress livePoolProgress;
    private final InstanceRefreshWarmPoolProgress warmPoolProgress;

    private InstanceRefreshProgressDetails(BuilderImpl builder) {
        this.livePoolProgress = builder.livePoolProgress;
        this.warmPoolProgress = builder.warmPoolProgress;
    }

    public final InstanceRefreshLivePoolProgress livePoolProgress() {
        return this.livePoolProgress;
    }

    public final InstanceRefreshWarmPoolProgress warmPoolProgress() {
        return this.warmPoolProgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.livePoolProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmPoolProgress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRefreshProgressDetails)) {
            return false;
        }
        InstanceRefreshProgressDetails other = (InstanceRefreshProgressDetails)obj;
        return Objects.equals(this.livePoolProgress(), other.livePoolProgress()) && Objects.equals(this.warmPoolProgress(), other.warmPoolProgress());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRefreshProgressDetails").add("LivePoolProgress", (Object)this.livePoolProgress()).add("WarmPoolProgress", (Object)this.warmPoolProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LivePoolProgress": {
                return Optional.ofNullable(clazz.cast(this.livePoolProgress()));
            }
            case "WarmPoolProgress": {
                return Optional.ofNullable(clazz.cast(this.warmPoolProgress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LivePoolProgress", LIVE_POOL_PROGRESS_FIELD);
        map.put("WarmPoolProgress", WARM_POOL_PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceRefreshProgressDetails, T> g) {
        return obj -> g.apply((InstanceRefreshProgressDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceRefreshLivePoolProgress livePoolProgress;
        private InstanceRefreshWarmPoolProgress warmPoolProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRefreshProgressDetails model) {
            this.livePoolProgress(model.livePoolProgress);
            this.warmPoolProgress(model.warmPoolProgress);
        }

        public final InstanceRefreshLivePoolProgress.Builder getLivePoolProgress() {
            return this.livePoolProgress != null ? this.livePoolProgress.toBuilder() : null;
        }

        public final void setLivePoolProgress(InstanceRefreshLivePoolProgress.BuilderImpl livePoolProgress) {
            this.livePoolProgress = livePoolProgress != null ? livePoolProgress.build() : null;
        }

        @Override
        public final Builder livePoolProgress(InstanceRefreshLivePoolProgress livePoolProgress) {
            this.livePoolProgress = livePoolProgress;
            return this;
        }

        public final InstanceRefreshWarmPoolProgress.Builder getWarmPoolProgress() {
            return this.warmPoolProgress != null ? this.warmPoolProgress.toBuilder() : null;
        }

        public final void setWarmPoolProgress(InstanceRefreshWarmPoolProgress.BuilderImpl warmPoolProgress) {
            this.warmPoolProgress = warmPoolProgress != null ? warmPoolProgress.build() : null;
        }

        @Override
        public final Builder warmPoolProgress(InstanceRefreshWarmPoolProgress warmPoolProgress) {
            this.warmPoolProgress = warmPoolProgress;
            return this;
        }

        public InstanceRefreshProgressDetails build() {
            return new InstanceRefreshProgressDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRefreshProgressDetails> {
        public Builder livePoolProgress(InstanceRefreshLivePoolProgress var1);

        default public Builder livePoolProgress(Consumer<InstanceRefreshLivePoolProgress.Builder> livePoolProgress) {
            return this.livePoolProgress((InstanceRefreshLivePoolProgress)((InstanceRefreshLivePoolProgress.Builder)InstanceRefreshLivePoolProgress.builder().applyMutation(livePoolProgress)).build());
        }

        public Builder warmPoolProgress(InstanceRefreshWarmPoolProgress var1);

        default public Builder warmPoolProgress(Consumer<InstanceRefreshWarmPoolProgress.Builder> warmPoolProgress) {
            return this.warmPoolProgress((InstanceRefreshWarmPoolProgress)((InstanceRefreshWarmPoolProgress.Builder)InstanceRefreshWarmPoolProgress.builder().applyMutation(warmPoolProgress)).build());
        }
    }
}

