/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier;
import software.amazon.awssdk.services.autoscaling.model.TrafficSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachTrafficSourcesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DetachTrafficSourcesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(DetachTrafficSourcesRequest.getter(DetachTrafficSourcesRequest::autoScalingGroupName)).setter(DetachTrafficSourcesRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<TrafficSourceIdentifier>> TRAFFIC_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficSources").getter(DetachTrafficSourcesRequest.getter(DetachTrafficSourcesRequest::trafficSources)).setter(DetachTrafficSourcesRequest.setter(Builder::trafficSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficSourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, TRAFFIC_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetachTrafficSourcesRequest.memberNameToFieldInitializer();
    private final String autoScalingGroupName;
    private final List<TrafficSourceIdentifier> trafficSources;

    private DetachTrafficSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.trafficSources = builder.trafficSources;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final boolean hasTrafficSources() {
        return this.trafficSources != null && !(this.trafficSources instanceof SdkAutoConstructList);
    }

    public final List<TrafficSourceIdentifier> trafficSources() {
        return this.trafficSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficSources() ? this.trafficSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachTrafficSourcesRequest)) {
            return false;
        }
        DetachTrafficSourcesRequest other = (DetachTrafficSourcesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && this.hasTrafficSources() == other.hasTrafficSources() && Objects.equals(this.trafficSources(), other.trafficSources());
    }

    public final String toString() {
        return ToString.builder((String)"DetachTrafficSourcesRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("TrafficSources", this.hasTrafficSources() ? this.trafficSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "TrafficSources": {
                return Optional.ofNullable(clazz.cast(this.trafficSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("TrafficSources", TRAFFIC_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetachTrafficSourcesRequest, T> g) {
        return obj -> g.apply((DetachTrafficSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<TrafficSourceIdentifier> trafficSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetachTrafficSourcesRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.trafficSources(model.trafficSources);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final List<TrafficSourceIdentifier.Builder> getTrafficSources() {
            List<TrafficSourceIdentifier.Builder> result = TrafficSourcesCopier.copyToBuilder(this.trafficSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficSources(Collection<TrafficSourceIdentifier.BuilderImpl> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copyFromBuilder(trafficSources);
        }

        @Override
        public final Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copy(trafficSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(TrafficSourceIdentifier ... trafficSources) {
            this.trafficSources(Arrays.asList(trafficSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder> ... trafficSources) {
            this.trafficSources(Stream.of(trafficSources).map(c -> (TrafficSourceIdentifier)((TrafficSourceIdentifier.Builder)TrafficSourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachTrafficSourcesRequest build() {
            return new DetachTrafficSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetachTrafficSourcesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder trafficSources(Collection<TrafficSourceIdentifier> var1);

        public Builder trafficSources(TrafficSourceIdentifier ... var1);

        public Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

