/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.Instance;
import software.amazon.awssdk.services.autoscaling.model.InstancesCopier;
import software.amazon.awssdk.services.autoscaling.model.WarmPoolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWarmPoolResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeWarmPoolResponse> {
    private static final SdkField<WarmPoolConfiguration> WARM_POOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmPoolConfiguration").getter(DescribeWarmPoolResponse.getter(DescribeWarmPoolResponse::warmPoolConfiguration)).setter(DescribeWarmPoolResponse.setter(Builder::warmPoolConfiguration)).constructor(WarmPoolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolConfiguration").build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(DescribeWarmPoolResponse.getter(DescribeWarmPoolResponse::instances)).setter(DescribeWarmPoolResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWarmPoolResponse.getter(DescribeWarmPoolResponse::nextToken)).setter(DescribeWarmPoolResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WARM_POOL_CONFIGURATION_FIELD, INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWarmPoolResponse.memberNameToFieldInitializer();
    private final WarmPoolConfiguration warmPoolConfiguration;
    private final List<Instance> instances;
    private final String nextToken;

    private DescribeWarmPoolResponse(BuilderImpl builder) {
        super(builder);
        this.warmPoolConfiguration = builder.warmPoolConfiguration;
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    public final WarmPoolConfiguration warmPoolConfiguration() {
        return this.warmPoolConfiguration;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<Instance> instances() {
        return this.instances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.warmPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWarmPoolResponse)) {
            return false;
        }
        DescribeWarmPoolResponse other = (DescribeWarmPoolResponse)((Object)obj);
        return Objects.equals(this.warmPoolConfiguration(), other.warmPoolConfiguration()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWarmPoolResponse").add("WarmPoolConfiguration", (Object)this.warmPoolConfiguration()).add("Instances", this.hasInstances() ? this.instances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WarmPoolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.warmPoolConfiguration()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WarmPoolConfiguration", WARM_POOL_CONFIGURATION_FIELD);
        map.put("Instances", INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWarmPoolResponse, T> g) {
        return obj -> g.apply((DescribeWarmPoolResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private WarmPoolConfiguration warmPoolConfiguration;
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWarmPoolResponse model) {
            super(model);
            this.warmPoolConfiguration(model.warmPoolConfiguration);
            this.instances(model.instances);
            this.nextToken(model.nextToken);
        }

        public final WarmPoolConfiguration.Builder getWarmPoolConfiguration() {
            return this.warmPoolConfiguration != null ? this.warmPoolConfiguration.toBuilder() : null;
        }

        public final void setWarmPoolConfiguration(WarmPoolConfiguration.BuilderImpl warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration != null ? warmPoolConfiguration.build() : null;
        }

        @Override
        public final Builder warmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration;
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWarmPoolResponse build() {
            return new DescribeWarmPoolResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWarmPoolResponse> {
        public Builder warmPoolConfiguration(WarmPoolConfiguration var1);

        default public Builder warmPoolConfiguration(Consumer<WarmPoolConfiguration.Builder> warmPoolConfiguration) {
            return this.warmPoolConfiguration((WarmPoolConfiguration)((WarmPoolConfiguration.Builder)WarmPoolConfiguration.builder().applyMutation(warmPoolConfiguration)).build());
        }

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

