/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.CapacityReservationIdsCopier;
import software.amazon.awssdk.services.autoscaling.model.CapacityReservationResourceGroupArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationTarget> {
    private static final SdkField<List<String>> CAPACITY_RESERVATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationIds").getter(CapacityReservationTarget.getter(CapacityReservationTarget::capacityReservationIds)).setter(CapacityReservationTarget.setter(Builder::capacityReservationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPACITY_RESERVATION_RESOURCE_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationResourceGroupArns").getter(CapacityReservationTarget.getter(CapacityReservationTarget::capacityReservationResourceGroupArns)).setter(CapacityReservationTarget.setter(Builder::capacityReservationResourceGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationResourceGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_IDS_FIELD, CAPACITY_RESERVATION_RESOURCE_GROUP_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservationTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> capacityReservationIds;
    private final List<String> capacityReservationResourceGroupArns;

    private CapacityReservationTarget(BuilderImpl builder) {
        this.capacityReservationIds = builder.capacityReservationIds;
        this.capacityReservationResourceGroupArns = builder.capacityReservationResourceGroupArns;
    }

    public final boolean hasCapacityReservationIds() {
        return this.capacityReservationIds != null && !(this.capacityReservationIds instanceof SdkAutoConstructList);
    }

    public final List<String> capacityReservationIds() {
        return this.capacityReservationIds;
    }

    public final boolean hasCapacityReservationResourceGroupArns() {
        return this.capacityReservationResourceGroupArns != null && !(this.capacityReservationResourceGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> capacityReservationResourceGroupArns() {
        return this.capacityReservationResourceGroupArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationIds() ? this.capacityReservationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationResourceGroupArns() ? this.capacityReservationResourceGroupArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationTarget)) {
            return false;
        }
        CapacityReservationTarget other = (CapacityReservationTarget)obj;
        return this.hasCapacityReservationIds() == other.hasCapacityReservationIds() && Objects.equals(this.capacityReservationIds(), other.capacityReservationIds()) && this.hasCapacityReservationResourceGroupArns() == other.hasCapacityReservationResourceGroupArns() && Objects.equals(this.capacityReservationResourceGroupArns(), other.capacityReservationResourceGroupArns());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationTarget").add("CapacityReservationIds", this.hasCapacityReservationIds() ? this.capacityReservationIds() : null).add("CapacityReservationResourceGroupArns", this.hasCapacityReservationResourceGroupArns() ? this.capacityReservationResourceGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationIds": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationIds()));
            }
            case "CapacityReservationResourceGroupArns": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationResourceGroupArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("CapacityReservationIds", CAPACITY_RESERVATION_IDS_FIELD);
        map.put("CapacityReservationResourceGroupArns", CAPACITY_RESERVATION_RESOURCE_GROUP_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationTarget, T> g) {
        return obj -> g.apply((CapacityReservationTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> capacityReservationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> capacityReservationResourceGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationTarget model) {
            this.capacityReservationIds(model.capacityReservationIds);
            this.capacityReservationResourceGroupArns(model.capacityReservationResourceGroupArns);
        }

        public final Collection<String> getCapacityReservationIds() {
            if (this.capacityReservationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityReservationIds;
        }

        public final void setCapacityReservationIds(Collection<String> capacityReservationIds) {
            this.capacityReservationIds = CapacityReservationIdsCopier.copy(capacityReservationIds);
        }

        @Override
        public final Builder capacityReservationIds(Collection<String> capacityReservationIds) {
            this.capacityReservationIds = CapacityReservationIdsCopier.copy(capacityReservationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationIds(String ... capacityReservationIds) {
            this.capacityReservationIds(Arrays.asList(capacityReservationIds));
            return this;
        }

        public final Collection<String> getCapacityReservationResourceGroupArns() {
            if (this.capacityReservationResourceGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityReservationResourceGroupArns;
        }

        public final void setCapacityReservationResourceGroupArns(Collection<String> capacityReservationResourceGroupArns) {
            this.capacityReservationResourceGroupArns = CapacityReservationResourceGroupArnsCopier.copy(capacityReservationResourceGroupArns);
        }

        @Override
        public final Builder capacityReservationResourceGroupArns(Collection<String> capacityReservationResourceGroupArns) {
            this.capacityReservationResourceGroupArns = CapacityReservationResourceGroupArnsCopier.copy(capacityReservationResourceGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationResourceGroupArns(String ... capacityReservationResourceGroupArns) {
            this.capacityReservationResourceGroupArns(Arrays.asList(capacityReservationResourceGroupArns));
            return this;
        }

        public CapacityReservationTarget build() {
            return new CapacityReservationTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationTarget> {
        public Builder capacityReservationIds(Collection<String> var1);

        public Builder capacityReservationIds(String ... var1);

        public Builder capacityReservationResourceGroupArns(Collection<String> var1);

        public Builder capacityReservationResourceGroupArns(String ... var1);
    }
}

