/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse;

public class DescribeInstanceRefreshesIterable
implements SdkIterable<DescribeInstanceRefreshesResponse> {
    private final AutoScalingClient client;
    private final DescribeInstanceRefreshesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceRefreshesIterable(AutoScalingClient client, DescribeInstanceRefreshesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstanceRefreshesResponseFetcher();
    }

    public Iterator<DescribeInstanceRefreshesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeInstanceRefreshesResponseFetcher
    implements SyncPageFetcher<DescribeInstanceRefreshesResponse> {
        private DescribeInstanceRefreshesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceRefreshesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceRefreshesResponse nextPage(DescribeInstanceRefreshesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceRefreshesIterable.this.client.describeInstanceRefreshes(DescribeInstanceRefreshesIterable.this.firstRequest);
            }
            return DescribeInstanceRefreshesIterable.this.client.describeInstanceRefreshes((DescribeInstanceRefreshesRequest)((Object)DescribeInstanceRefreshesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

