/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.waiters.AutoScalingWaiter;
import software.amazon.awssdk.services.autoscaling.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultAutoScalingWaiter
implements AutoScalingWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final AutoScalingClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeAutoScalingGroupsResponse> groupExistsWaiter;
    private final Waiter<DescribeAutoScalingGroupsResponse> groupInServiceWaiter;
    private final Waiter<DescribeAutoScalingGroupsResponse> groupNotExistsWaiter;

    private DefaultAutoScalingWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AutoScalingClient)AutoScalingClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.groupExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAutoScalingGroupsResponse.class).acceptors(DefaultAutoScalingWaiter.groupExistsWaiterAcceptors())).overrideConfiguration(DefaultAutoScalingWaiter.groupExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.groupInServiceWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAutoScalingGroupsResponse.class).acceptors(DefaultAutoScalingWaiter.groupInServiceWaiterAcceptors())).overrideConfiguration(DefaultAutoScalingWaiter.groupInServiceWaiterConfig(builder.overrideConfiguration))).build();
        this.groupNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAutoScalingGroupsResponse.class).acceptors(DefaultAutoScalingWaiter.groupNotExistsWaiterAcceptors())).overrideConfiguration(DefaultAutoScalingWaiter.groupNotExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeAutoScalingGroupsResponse> waitUntilGroupExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return this.groupExistsWaiter.run(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeAutoScalingGroupsResponse> waitUntilGroupExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.groupExistsWaiter.run(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)), DefaultAutoScalingWaiter.groupExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAutoScalingGroupsResponse> waitUntilGroupInService(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return this.groupInServiceWaiter.run(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeAutoScalingGroupsResponse> waitUntilGroupInService(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.groupInServiceWaiter.run(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)), DefaultAutoScalingWaiter.groupInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAutoScalingGroupsResponse> waitUntilGroupNotExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return this.groupNotExistsWaiter.run(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeAutoScalingGroupsResponse> waitUntilGroupNotExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.groupNotExistsWaiter.run(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)), DefaultAutoScalingWaiter.groupNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> groupExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), false);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> groupInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").flatten().multiSelectList(x0 -> x0.field("Instances").filter(x1 -> x1.field("LifecycleState").compare("==", x1.constant("InService"))).length().compare(">=", x0.field("MinSize"))).flatten().contains(input.constant(false)).value(), false);
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").flatten().multiSelectList(x0 -> x0.field("Instances").filter(x1 -> x1.field("LifecycleState").compare("==", x1.constant("InService"))).length().compare(">=", x0.field("MinSize"))).flatten().contains(input.constant(false)).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> groupNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), false);
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration groupExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration groupInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration groupNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AutoScalingWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AutoScalingRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AutoScalingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AutoScalingWaiter.Builder {
        private AutoScalingClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public AutoScalingWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AutoScalingWaiter.Builder client(AutoScalingClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AutoScalingWaiter build() {
            return new DefaultAutoScalingWaiter(this);
        }
    }
}

