/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;

public class DescribeNotificationConfigurationsIterable
implements SdkIterable<DescribeNotificationConfigurationsResponse> {
    private final AutoScalingClient client;
    private final DescribeNotificationConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNotificationConfigurationsIterable(AutoScalingClient client, DescribeNotificationConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNotificationConfigurationsResponseFetcher();
    }

    public Iterator<DescribeNotificationConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationConfiguration> notificationConfigurations() {
        Function<DescribeNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationConfigurations() != null) {
                return response.notificationConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNotificationConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeNotificationConfigurationsResponse> {
        private DescribeNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNotificationConfigurationsResponse nextPage(DescribeNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationConfigurationsIterable.this.client.describeNotificationConfigurations(DescribeNotificationConfigurationsIterable.this.firstRequest);
            }
            return DescribeNotificationConfigurationsIterable.this.client.describeNotificationConfigurations((DescribeNotificationConfigurationsRequest)((Object)DescribeNotificationConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

