/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledActionNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledActionsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeScheduledActionsRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::autoScalingGroupName)).setter(DescribeScheduledActionsRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<String>> SCHEDULED_ACTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledActionNames").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::scheduledActionNames)).setter(DescribeScheduledActionsRequest.setter(Builder::scheduledActionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::startTime)).setter(DescribeScheduledActionsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::endTime)).setter(DescribeScheduledActionsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::nextToken)).setter(DescribeScheduledActionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::maxRecords)).setter(DescribeScheduledActionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, SCHEDULED_ACTION_NAMES_FIELD, START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));
    private final String autoScalingGroupName;
    private final List<String> scheduledActionNames;
    private final Instant startTime;
    private final Instant endTime;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeScheduledActionsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionNames = builder.scheduledActionNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final boolean hasScheduledActionNames() {
        return this.scheduledActionNames != null && !(this.scheduledActionNames instanceof SdkAutoConstructList);
    }

    public final List<String> scheduledActionNames() {
        return this.scheduledActionNames;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledActionNames() ? this.scheduledActionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsRequest)) {
            return false;
        }
        DescribeScheduledActionsRequest other = (DescribeScheduledActionsRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && this.hasScheduledActionNames() == other.hasScheduledActionNames() && Objects.equals(this.scheduledActionNames(), other.scheduledActionNames()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScheduledActionsRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScheduledActionNames", this.hasScheduledActionNames() ? this.scheduledActionNames() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScheduledActionNames": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionNames()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsRequest, T> g) {
        return obj -> g.apply((DescribeScheduledActionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scheduledActionNames = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scheduledActionNames(model.scheduledActionNames);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Collection<String> getScheduledActionNames() {
            if (this.scheduledActionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduledActionNames;
        }

        public final void setScheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
        }

        @Override
        public final Builder scheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActionNames(String ... scheduledActionNames) {
            this.scheduledActionNames(Arrays.asList(scheduledActionNames));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledActionsRequest build() {
            return new DescribeScheduledActionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledActionsRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledActionNames(Collection<String> var1);

        public Builder scheduledActionNames(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

