/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuspendedProcess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuspendedProcess> {
    private static final SdkField<String> PROCESS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessName").getter(SuspendedProcess.getter(SuspendedProcess::processName)).setter(SuspendedProcess.setter(Builder::processName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessName").build()}).build();
    private static final SdkField<String> SUSPENSION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuspensionReason").getter(SuspendedProcess.getter(SuspendedProcess::suspensionReason)).setter(SuspendedProcess.setter(Builder::suspensionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspensionReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESS_NAME_FIELD, SUSPENSION_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String processName;
    private final String suspensionReason;

    private SuspendedProcess(BuilderImpl builder) {
        this.processName = builder.processName;
        this.suspensionReason = builder.suspensionReason;
    }

    public final String processName() {
        return this.processName;
    }

    public final String suspensionReason() {
        return this.suspensionReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.processName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspensionReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendedProcess)) {
            return false;
        }
        SuspendedProcess other = (SuspendedProcess)obj;
        return Objects.equals(this.processName(), other.processName()) && Objects.equals(this.suspensionReason(), other.suspensionReason());
    }

    public final String toString() {
        return ToString.builder((String)"SuspendedProcess").add("ProcessName", (Object)this.processName()).add("SuspensionReason", (Object)this.suspensionReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessName": {
                return Optional.ofNullable(clazz.cast(this.processName()));
            }
            case "SuspensionReason": {
                return Optional.ofNullable(clazz.cast(this.suspensionReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuspendedProcess, T> g) {
        return obj -> g.apply((SuspendedProcess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String processName;
        private String suspensionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendedProcess model) {
            this.processName(model.processName);
            this.suspensionReason(model.suspensionReason);
        }

        public final String getProcessName() {
            return this.processName;
        }

        public final void setProcessName(String processName) {
            this.processName = processName;
        }

        @Override
        public final Builder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public final String getSuspensionReason() {
            return this.suspensionReason;
        }

        public final void setSuspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
        }

        @Override
        public final Builder suspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
            return this;
        }

        public SuspendedProcess build() {
            return new SuspendedProcess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuspendedProcess> {
        public Builder processName(String var1);

        public Builder suspensionReason(String var1);
    }
}

