/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroupNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNotificationConfigurationsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeNotificationConfigurationsRequest> {
    private static final SdkField<List<String>> AUTO_SCALING_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoScalingGroupNames").getter(DescribeNotificationConfigurationsRequest.getter(DescribeNotificationConfigurationsRequest::autoScalingGroupNames)).setter(DescribeNotificationConfigurationsRequest.setter(Builder::autoScalingGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNotificationConfigurationsRequest.getter(DescribeNotificationConfigurationsRequest::nextToken)).setter(DescribeNotificationConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeNotificationConfigurationsRequest.getter(DescribeNotificationConfigurationsRequest::maxRecords)).setter(DescribeNotificationConfigurationsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));
    private final List<String> autoScalingGroupNames;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeNotificationConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupNames = builder.autoScalingGroupNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public final boolean hasAutoScalingGroupNames() {
        return this.autoScalingGroupNames != null && !(this.autoScalingGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> autoScalingGroupNames() {
        return this.autoScalingGroupNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroupNames() ? this.autoScalingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsRequest)) {
            return false;
        }
        DescribeNotificationConfigurationsRequest other = (DescribeNotificationConfigurationsRequest)((Object)obj);
        return this.hasAutoScalingGroupNames() == other.hasAutoScalingGroupNames() && Objects.equals(this.autoScalingGroupNames(), other.autoScalingGroupNames()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNotificationConfigurationsRequest").add("AutoScalingGroupNames", this.hasAutoScalingGroupNames() ? this.autoScalingGroupNames() : null).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeNotificationConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> autoScalingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsRequest model) {
            super(model);
            this.autoScalingGroupNames(model.autoScalingGroupNames);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final Collection<String> getAutoScalingGroupNames() {
            if (this.autoScalingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroupNames;
        }

        public final void setAutoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
        }

        @Override
        public final Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupNames(String ... autoScalingGroupNames) {
            this.autoScalingGroupNames(Arrays.asList(autoScalingGroupNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNotificationConfigurationsRequest build() {
            return new DescribeNotificationConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNotificationConfigurationsRequest> {
        public Builder autoScalingGroupNames(Collection<String> var1);

        public Builder autoScalingGroupNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

