/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.WarmPoolState;
import software.amazon.awssdk.services.autoscaling.model.WarmPoolStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WarmPoolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WarmPoolConfiguration> {
    private static final SdkField<Integer> MAX_GROUP_PREPARED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxGroupPreparedCapacity").getter(WarmPoolConfiguration.getter(WarmPoolConfiguration::maxGroupPreparedCapacity)).setter(WarmPoolConfiguration.setter(Builder::maxGroupPreparedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxGroupPreparedCapacity").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSize").getter(WarmPoolConfiguration.getter(WarmPoolConfiguration::minSize)).setter(WarmPoolConfiguration.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<String> POOL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolState").getter(WarmPoolConfiguration.getter(WarmPoolConfiguration::poolStateAsString)).setter(WarmPoolConfiguration.setter(Builder::poolState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolState").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(WarmPoolConfiguration.getter(WarmPoolConfiguration::statusAsString)).setter(WarmPoolConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_GROUP_PREPARED_CAPACITY_FIELD, MIN_SIZE_FIELD, POOL_STATE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxGroupPreparedCapacity;
    private final Integer minSize;
    private final String poolState;
    private final String status;

    private WarmPoolConfiguration(BuilderImpl builder) {
        this.maxGroupPreparedCapacity = builder.maxGroupPreparedCapacity;
        this.minSize = builder.minSize;
        this.poolState = builder.poolState;
        this.status = builder.status;
    }

    public final Integer maxGroupPreparedCapacity() {
        return this.maxGroupPreparedCapacity;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final WarmPoolState poolState() {
        return WarmPoolState.fromValue(this.poolState);
    }

    public final String poolStateAsString() {
        return this.poolState;
    }

    public final WarmPoolStatus status() {
        return WarmPoolStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxGroupPreparedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarmPoolConfiguration)) {
            return false;
        }
        WarmPoolConfiguration other = (WarmPoolConfiguration)obj;
        return Objects.equals(this.maxGroupPreparedCapacity(), other.maxGroupPreparedCapacity()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.poolStateAsString(), other.poolStateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WarmPoolConfiguration").add("MaxGroupPreparedCapacity", (Object)this.maxGroupPreparedCapacity()).add("MinSize", (Object)this.minSize()).add("PoolState", (Object)this.poolStateAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxGroupPreparedCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxGroupPreparedCapacity()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "PoolState": {
                return Optional.ofNullable(clazz.cast(this.poolStateAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WarmPoolConfiguration, T> g) {
        return obj -> g.apply((WarmPoolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxGroupPreparedCapacity;
        private Integer minSize;
        private String poolState;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(WarmPoolConfiguration model) {
            this.maxGroupPreparedCapacity(model.maxGroupPreparedCapacity);
            this.minSize(model.minSize);
            this.poolState(model.poolState);
            this.status(model.status);
        }

        public final Integer getMaxGroupPreparedCapacity() {
            return this.maxGroupPreparedCapacity;
        }

        @Override
        public final Builder maxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        public final void setMaxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final String getPoolState() {
            return this.poolState;
        }

        @Override
        public final Builder poolState(String poolState) {
            this.poolState = poolState;
            return this;
        }

        @Override
        public final Builder poolState(WarmPoolState poolState) {
            this.poolState(poolState == null ? null : poolState.toString());
            return this;
        }

        public final void setPoolState(String poolState) {
            this.poolState = poolState;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WarmPoolStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public WarmPoolConfiguration build() {
            return new WarmPoolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WarmPoolConfiguration> {
        public Builder maxGroupPreparedCapacity(Integer var1);

        public Builder minSize(Integer var1);

        public Builder poolState(String var1);

        public Builder poolState(WarmPoolState var1);

        public Builder status(String var1);

        public Builder status(WarmPoolStatus var1);
    }
}

