/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.waiters.AutoScalingAsyncWaiter;
import software.amazon.awssdk.services.autoscaling.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultAutoScalingAsyncWaiter
implements AutoScalingAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final AutoScalingAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeAutoScalingGroupsResponse> groupExistsWaiter;
    private final AsyncWaiter<DescribeAutoScalingGroupsResponse> groupInServiceWaiter;
    private final AsyncWaiter<DescribeAutoScalingGroupsResponse> groupNotExistsWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultAutoScalingAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AutoScalingAsyncClient)AutoScalingAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.groupExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAutoScalingGroupsResponse.class).acceptors(DefaultAutoScalingAsyncWaiter.groupExistsWaiterAcceptors())).overrideConfiguration(DefaultAutoScalingAsyncWaiter.groupExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.groupInServiceWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAutoScalingGroupsResponse.class).acceptors(DefaultAutoScalingAsyncWaiter.groupInServiceWaiterAcceptors())).overrideConfiguration(DefaultAutoScalingAsyncWaiter.groupInServiceWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.groupNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAutoScalingGroupsResponse.class).acceptors(DefaultAutoScalingAsyncWaiter.groupNotExistsWaiterAcceptors())).overrideConfiguration(DefaultAutoScalingAsyncWaiter.groupNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAutoScalingGroupsResponse>> waitUntilGroupExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return this.groupExistsWaiter.runAsync(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAutoScalingGroupsResponse>> waitUntilGroupExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.groupExistsWaiter.runAsync(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)), DefaultAutoScalingAsyncWaiter.groupExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAutoScalingGroupsResponse>> waitUntilGroupInService(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return this.groupInServiceWaiter.runAsync(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAutoScalingGroupsResponse>> waitUntilGroupInService(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.groupInServiceWaiter.runAsync(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)), DefaultAutoScalingAsyncWaiter.groupInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAutoScalingGroupsResponse>> waitUntilGroupNotExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return this.groupNotExistsWaiter.runAsync(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAutoScalingGroupsResponse>> waitUntilGroupNotExists(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.groupNotExistsWaiter.runAsync(() -> this.client.describeAutoScalingGroups(this.applyWaitersUserAgent(describeAutoScalingGroupsRequest)), DefaultAutoScalingAsyncWaiter.groupNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> groupExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), false);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> groupInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").flatten().multiSelectList(x0 -> x0.field("Instances").filter(x1 -> x1.field("LifecycleState").compare("==", x1.constant("InService"))).length().compare(">=", x0.field("MinSize"))).flatten().contains(input.constant(false)).value(), false);
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").flatten().multiSelectList(x0 -> x0.field("Instances").filter(x1 -> x1.field("LifecycleState").compare("==", x1.constant("InService"))).length().compare(">=", x0.field("MinSize"))).flatten().contains(input.constant(false)).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> groupNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAutoScalingGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), false);
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AutoScalingGroups").length().compare(">", input.constant(0)).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration groupExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration groupInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration groupNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AutoScalingAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AutoScalingRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AutoScalingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AutoScalingAsyncWaiter.Builder {
        private AutoScalingAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public AutoScalingAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public AutoScalingAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AutoScalingAsyncWaiter.Builder client(AutoScalingAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AutoScalingAsyncWaiter build() {
            return new DefaultAutoScalingAsyncWaiter(this);
        }
    }
}

