/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefresh;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceRefreshesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeInstanceRefreshesResponse> {
    private static final SdkField<List<InstanceRefresh>> INSTANCE_REFRESHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceRefreshes").getter(DescribeInstanceRefreshesResponse.getter(DescribeInstanceRefreshesResponse::instanceRefreshes)).setter(DescribeInstanceRefreshesResponse.setter(Builder::instanceRefreshes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceRefresh::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceRefreshesResponse.getter(DescribeInstanceRefreshesResponse::nextToken)).setter(DescribeInstanceRefreshesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_REFRESHES_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceRefresh> instanceRefreshes;
    private final String nextToken;

    private DescribeInstanceRefreshesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceRefreshes = builder.instanceRefreshes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceRefreshes() {
        return this.instanceRefreshes != null && !(this.instanceRefreshes instanceof SdkAutoConstructList);
    }

    public final List<InstanceRefresh> instanceRefreshes() {
        return this.instanceRefreshes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceRefreshes() ? this.instanceRefreshes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceRefreshesResponse)) {
            return false;
        }
        DescribeInstanceRefreshesResponse other = (DescribeInstanceRefreshesResponse)((Object)obj);
        return this.hasInstanceRefreshes() == other.hasInstanceRefreshes() && Objects.equals(this.instanceRefreshes(), other.instanceRefreshes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceRefreshesResponse").add("InstanceRefreshes", this.hasInstanceRefreshes() ? this.instanceRefreshes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceRefreshes": {
                return Optional.ofNullable(clazz.cast(this.instanceRefreshes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceRefreshesResponse, T> g) {
        return obj -> g.apply((DescribeInstanceRefreshesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<InstanceRefresh> instanceRefreshes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceRefreshesResponse model) {
            super(model);
            this.instanceRefreshes(model.instanceRefreshes);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceRefresh.Builder> getInstanceRefreshes() {
            if (this.instanceRefreshes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceRefreshes != null ? (Collection)this.instanceRefreshes.stream().map(InstanceRefresh::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceRefreshes(Collection<InstanceRefresh> instanceRefreshes) {
            this.instanceRefreshes = InstanceRefreshesCopier.copy(instanceRefreshes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRefreshes(InstanceRefresh ... instanceRefreshes) {
            this.instanceRefreshes(Arrays.asList(instanceRefreshes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRefreshes(Consumer<InstanceRefresh.Builder> ... instanceRefreshes) {
            this.instanceRefreshes(Stream.of(instanceRefreshes).map(c -> (InstanceRefresh)((InstanceRefresh.Builder)InstanceRefresh.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceRefreshes(Collection<InstanceRefresh.BuilderImpl> instanceRefreshes) {
            this.instanceRefreshes = InstanceRefreshesCopier.copyFromBuilder(instanceRefreshes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceRefreshesResponse build() {
            return new DescribeInstanceRefreshesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceRefreshesResponse> {
        public Builder instanceRefreshes(Collection<InstanceRefresh> var1);

        public Builder instanceRefreshes(InstanceRefresh ... var1);

        public Builder instanceRefreshes(Consumer<InstanceRefresh.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

