/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshPreferences> {
    private static final SdkField<Integer> MIN_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinHealthyPercentage").getter(RefreshPreferences.getter(RefreshPreferences::minHealthyPercentage)).setter(RefreshPreferences.setter(Builder::minHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinHealthyPercentage").build()}).build();
    private static final SdkField<Integer> INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceWarmup").getter(RefreshPreferences.getter(RefreshPreferences::instanceWarmup)).setter(RefreshPreferences.setter(Builder::instanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceWarmup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_HEALTHY_PERCENTAGE_FIELD, INSTANCE_WARMUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minHealthyPercentage;
    private final Integer instanceWarmup;

    private RefreshPreferences(BuilderImpl builder) {
        this.minHealthyPercentage = builder.minHealthyPercentage;
        this.instanceWarmup = builder.instanceWarmup;
    }

    public Integer minHealthyPercentage() {
        return this.minHealthyPercentage;
    }

    public Integer instanceWarmup() {
        return this.instanceWarmup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceWarmup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshPreferences)) {
            return false;
        }
        RefreshPreferences other = (RefreshPreferences)obj;
        return Objects.equals(this.minHealthyPercentage(), other.minHealthyPercentage()) && Objects.equals(this.instanceWarmup(), other.instanceWarmup());
    }

    public String toString() {
        return ToString.builder((String)"RefreshPreferences").add("MinHealthyPercentage", (Object)this.minHealthyPercentage()).add("InstanceWarmup", (Object)this.instanceWarmup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.minHealthyPercentage()));
            }
            case "InstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.instanceWarmup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshPreferences, T> g) {
        return obj -> g.apply((RefreshPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minHealthyPercentage;
        private Integer instanceWarmup;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshPreferences model) {
            this.minHealthyPercentage(model.minHealthyPercentage);
            this.instanceWarmup(model.instanceWarmup);
        }

        public final Integer getMinHealthyPercentage() {
            return this.minHealthyPercentage;
        }

        @Override
        public final Builder minHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        public final void setMinHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
        }

        public final Integer getInstanceWarmup() {
            return this.instanceWarmup;
        }

        @Override
        public final Builder instanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
            return this;
        }

        public final void setInstanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
        }

        public RefreshPreferences build() {
            return new RefreshPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshPreferences> {
        public Builder minHealthyPercentage(Integer var1);

        public Builder instanceWarmup(Integer var1);
    }
}

