/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupAction;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledActionsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<List<ScheduledUpdateGroupAction>> SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledUpdateGroupActions").getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::scheduledUpdateGroupActions)).setter(DescribeScheduledActionsResponse.setter(Builder::scheduledUpdateGroupActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateGroupActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledUpdateGroupAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::nextToken)).setter(DescribeScheduledActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;
    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasScheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions != null && !(this.scheduledUpdateGroupActions instanceof SdkAutoConstructList);
    }

    public List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledUpdateGroupActions() ? this.scheduledUpdateGroupActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse)((Object)obj);
        return this.hasScheduledUpdateGroupActions() == other.hasScheduledUpdateGroupActions() && Objects.equals(this.scheduledUpdateGroupActions(), other.scheduledUpdateGroupActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScheduledActionsResponse").add("ScheduledUpdateGroupActions", this.hasScheduledUpdateGroupActions() ? this.scheduledUpdateGroupActions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledUpdateGroupActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledUpdateGroupActions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            this.scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScheduledUpdateGroupAction.Builder> getScheduledUpdateGroupActions() {
            if (this.scheduledUpdateGroupActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduledUpdateGroupActions != null ? (Collection)this.scheduledUpdateGroupActions.stream().map(ScheduledUpdateGroupAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupAction.Builder> ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Stream.of(scheduledUpdateGroupActions).map(c -> (ScheduledUpdateGroupAction)((ScheduledUpdateGroupAction.Builder)ScheduledUpdateGroupAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copyFromBuilder(scheduledUpdateGroupActions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        public Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> var1);

        public Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... var1);

        public Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupAction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

