/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingNotificationTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoScalingNotificationTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
    private static final SdkField<List<String>> AUTO_SCALING_NOTIFICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoScalingNotificationTypes").getter(DescribeAutoScalingNotificationTypesResponse.getter(DescribeAutoScalingNotificationTypesResponse::autoScalingNotificationTypes)).setter(DescribeAutoScalingNotificationTypesResponse.setter(Builder::autoScalingNotificationTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingNotificationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_NOTIFICATION_TYPES_FIELD));
    private final List<String> autoScalingNotificationTypes;

    private DescribeAutoScalingNotificationTypesResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingNotificationTypes = builder.autoScalingNotificationTypes;
    }

    public boolean hasAutoScalingNotificationTypes() {
        return this.autoScalingNotificationTypes != null && !(this.autoScalingNotificationTypes instanceof SdkAutoConstructList);
    }

    public List<String> autoScalingNotificationTypes() {
        return this.autoScalingNotificationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingNotificationTypes() ? this.autoScalingNotificationTypes() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingNotificationTypesResponse)) {
            return false;
        }
        DescribeAutoScalingNotificationTypesResponse other = (DescribeAutoScalingNotificationTypesResponse)((Object)obj);
        return this.hasAutoScalingNotificationTypes() == other.hasAutoScalingNotificationTypes() && Objects.equals(this.autoScalingNotificationTypes(), other.autoScalingNotificationTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAutoScalingNotificationTypesResponse").add("AutoScalingNotificationTypes", this.hasAutoScalingNotificationTypes() ? this.autoScalingNotificationTypes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingNotificationTypes": {
                return Optional.ofNullable(clazz.cast(this.autoScalingNotificationTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoScalingNotificationTypesResponse, T> g) {
        return obj -> g.apply((DescribeAutoScalingNotificationTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<String> autoScalingNotificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingNotificationTypesResponse model) {
            super(model);
            this.autoScalingNotificationTypes(model.autoScalingNotificationTypes);
        }

        public final Collection<String> getAutoScalingNotificationTypes() {
            if (this.autoScalingNotificationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingNotificationTypes;
        }

        @Override
        public final Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingNotificationTypes(String ... autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes(Arrays.asList(autoScalingNotificationTypes));
            return this;
        }

        public final void setAutoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
        }

        @Override
        public DescribeAutoScalingNotificationTypesResponse build() {
            return new DescribeAutoScalingNotificationTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
        public Builder autoScalingNotificationTypes(Collection<String> var1);

        public Builder autoScalingNotificationTypes(String ... var1);
    }
}

