/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.Alarm;
import software.amazon.awssdk.services.autoscaling.model.AlarmsCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutScalingPolicyResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, PutScalingPolicyResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyARN").getter(PutScalingPolicyResponse.getter(PutScalingPolicyResponse::policyARN)).setter(PutScalingPolicyResponse.setter(Builder::policyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyARN").build()}).build();
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(PutScalingPolicyResponse.getter(PutScalingPolicyResponse::alarms)).setter(PutScalingPolicyResponse.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, ALARMS_FIELD));
    private final String policyARN;
    private final List<Alarm> alarms;

    private PutScalingPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyARN = builder.policyARN;
        this.alarms = builder.alarms;
    }

    public String policyARN() {
        return this.policyARN;
    }

    public boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResponse)) {
            return false;
        }
        PutScalingPolicyResponse other = (PutScalingPolicyResponse)((Object)obj);
        return Objects.equals(this.policyARN(), other.policyARN()) && Objects.equals(this.alarms(), other.alarms());
    }

    public String toString() {
        return ToString.builder((String)"PutScalingPolicyResponse").add("PolicyARN", (Object)this.policyARN()).add("Alarms", this.alarms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyARN": {
                return Optional.ofNullable(clazz.cast(this.policyARN()));
            }
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyResponse, T> g) {
        return obj -> g.apply((PutScalingPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private String policyARN;
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyResponse model) {
            super(model);
            this.policyARN(model.policyARN);
            this.alarms(model.alarms);
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder> ... alarms) {
            this.alarms(Stream.of(alarms).map(c -> (Alarm)((Alarm.Builder)Alarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        @Override
        public PutScalingPolicyResponse build() {
            return new PutScalingPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutScalingPolicyResponse> {
        public Builder policyARN(String var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder alarms(Consumer<Alarm.Builder> ... var1);
    }
}

