/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.InstanceMetadataEndpointState;
import software.amazon.awssdk.services.autoscaling.model.InstanceMetadataHttpTokensState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMetadataOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMetadataOptions> {
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpTokensAsString)).setter(InstanceMetadataOptions.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpPutResponseHopLimit)).setter(InstanceMetadataOptions.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpEndpointAsString)).setter(InstanceMetadataOptions.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_TOKENS_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_ENDPOINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String httpTokens;
    private final Integer httpPutResponseHopLimit;
    private final String httpEndpoint;

    private InstanceMetadataOptions(BuilderImpl builder) {
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpEndpoint = builder.httpEndpoint;
    }

    public InstanceMetadataHttpTokensState httpTokens() {
        return InstanceMetadataHttpTokensState.fromValue(this.httpTokens);
    }

    public String httpTokensAsString() {
        return this.httpTokens;
    }

    public Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public InstanceMetadataEndpointState httpEndpoint() {
        return InstanceMetadataEndpointState.fromValue(this.httpEndpoint);
    }

    public String httpEndpointAsString() {
        return this.httpEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataOptions)) {
            return false;
        }
        InstanceMetadataOptions other = (InstanceMetadataOptions)obj;
        return Objects.equals(this.httpTokensAsString(), other.httpTokensAsString()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpEndpointAsString(), other.httpEndpointAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceMetadataOptions").add("HttpTokens", (Object)this.httpTokensAsString()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpEndpoint", (Object)this.httpEndpointAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokensAsString()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataOptions, T> g) {
        return obj -> g.apply((InstanceMetadataOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpTokens;
        private Integer httpPutResponseHopLimit;
        private String httpEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataOptions model) {
            this.httpTokens(model.httpTokens);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpEndpoint(model.httpEndpoint);
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(InstanceMetadataHttpTokensState httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(InstanceMetadataEndpointState httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        public InstanceMetadataOptions build() {
            return new InstanceMetadataOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMetadataOptions> {
        public Builder httpTokens(String var1);

        public Builder httpTokens(InstanceMetadataHttpTokensState var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpEndpoint(String var1);

        public Builder httpEndpoint(InstanceMetadataEndpointState var1);
    }
}

