/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;

public class DisableMetricsCollectionRequestMarshaller
implements Marshaller<Request<DisableMetricsCollectionRequest>, DisableMetricsCollectionRequest> {
    public Request<DisableMetricsCollectionRequest> marshall(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        List<String> metricsList;
        if (disableMetricsCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)disableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "DisableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)disableMetricsCollectionRequest.autoScalingGroupName()));
        }
        if ((metricsList = disableMetricsCollectionRequest.metrics()) != null) {
            if (!metricsList.isEmpty()) {
                int metricsListIndex = 1;
                for (String metricsListValue : metricsList) {
                    if (metricsListValue != null) {
                        request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
                    }
                    ++metricsListIndex;
                }
            } else {
                request.addParameter("Metrics", "");
            }
        }
        return request;
    }
}

