/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.MetricDimension;
import software.amazon.awssdk.services.autoscaling.transform.MetricDimensionUnmarshaller;

public class CustomizedMetricSpecificationUnmarshaller
implements Unmarshaller<CustomizedMetricSpecification, StaxUnmarshallerContext> {
    private static final CustomizedMetricSpecificationUnmarshaller INSTANCE = new CustomizedMetricSpecificationUnmarshaller();

    public CustomizedMetricSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomizedMetricSpecification.Builder customizedMetricSpecification;
        block9: {
            customizedMetricSpecification = CustomizedMetricSpecification.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<MetricDimension> dimensions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    customizedMetricSpecification.dimensions(dimensions);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("MetricName", targetDepth)) {
                        customizedMetricSpecification.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Namespace", targetDepth)) {
                        customizedMetricSpecification.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Dimensions", targetDepth)) {
                        dimensions = new ArrayList<MetricDimension>();
                        continue;
                    }
                    if (context.testExpression("Dimensions/member", targetDepth)) {
                        dimensions.add(MetricDimensionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Statistic", targetDepth)) {
                        customizedMetricSpecification.statistic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Unit", targetDepth)) continue;
                    customizedMetricSpecification.unit(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            customizedMetricSpecification.dimensions(dimensions);
        }
        return (CustomizedMetricSpecification)customizedMetricSpecification.build();
    }

    public static CustomizedMetricSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

