/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateInstanceInAutoScalingGroupRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
    private final String instanceId;
    private final Boolean shouldDecrementDesiredCapacity;

    private TerminateInstanceInAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean shouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shouldDecrementDesiredCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupRequest)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupRequest other = (TerminateInstanceInAutoScalingGroupRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.shouldDecrementDesiredCapacity(), other.shouldDecrementDesiredCapacity());
    }

    public String toString() {
        return ToString.builder((String)"TerminateInstanceInAutoScalingGroupRequest").add("InstanceId", (Object)this.instanceId()).add("ShouldDecrementDesiredCapacity", (Object)this.shouldDecrementDesiredCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "ShouldDecrementDesiredCapacity": {
                return Optional.of(clazz.cast(this.shouldDecrementDesiredCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupRequest model) {
            this.instanceId(model.instanceId);
            this.shouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return this.shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TerminateInstanceInAutoScalingGroupRequest build() {
            return new TerminateInstanceInAutoScalingGroupRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
        public Builder instanceId(String var1);

        public Builder shouldDecrementDesiredCapacity(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

