/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetDesiredCapacityRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, SetDesiredCapacityRequest> {
    private final String autoScalingGroupName;
    private final Integer desiredCapacity;
    private final Boolean honorCooldown;

    private SetDesiredCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.desiredCapacity = builder.desiredCapacity;
        this.honorCooldown = builder.honorCooldown;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Boolean honorCooldown() {
        return this.honorCooldown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.honorCooldown());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDesiredCapacityRequest)) {
            return false;
        }
        SetDesiredCapacityRequest other = (SetDesiredCapacityRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.honorCooldown(), other.honorCooldown());
    }

    public String toString() {
        return ToString.builder((String)"SetDesiredCapacityRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("HonorCooldown", (Object)this.honorCooldown()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "DesiredCapacity": {
                return Optional.of(clazz.cast(this.desiredCapacity()));
            }
            case "HonorCooldown": {
                return Optional.of(clazz.cast(this.honorCooldown()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private Integer desiredCapacity;
        private Boolean honorCooldown;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDesiredCapacityRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.desiredCapacity(model.desiredCapacity);
            this.honorCooldown(model.honorCooldown);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Boolean getHonorCooldown() {
            return this.honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetDesiredCapacityRequest build() {
            return new SetDesiredCapacityRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, SetDesiredCapacityRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder desiredCapacity(Integer var1);

        public Builder honorCooldown(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

