/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.util.StringUtils;

public class DisableMetricsCollectionRequestMarshaller
implements Marshaller<Request<DisableMetricsCollectionRequest>, DisableMetricsCollectionRequest> {
    public Request<DisableMetricsCollectionRequest> marshall(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        List<String> metricsList;
        if (disableMetricsCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "DisableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)disableMetricsCollectionRequest.autoScalingGroupName()));
        }
        if ((metricsList = disableMetricsCollectionRequest.metrics()) != null) {
            if (!metricsList.isEmpty()) {
                int metricsListIndex = 1;
                for (String metricsListValue : metricsList) {
                    if (metricsListValue != null) {
                        request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
                    }
                    ++metricsListIndex;
                }
            } else {
                request.addParameter("Metrics", "");
            }
        }
        return request;
    }
}

