/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<UpdateAutoScalingGroupRequest>, UpdateAutoScalingGroupRequest> {
    public Request<UpdateAutoScalingGroupRequest> marshall(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        List<String> terminationPoliciesList;
        List<String> availabilityZonesList;
        if (updateAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "UpdateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)updateAutoScalingGroupRequest.autoScalingGroupName()));
        }
        if (updateAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)updateAutoScalingGroupRequest.launchConfigurationName()));
        }
        if (updateAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.minSize()));
        }
        if (updateAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.maxSize()));
        }
        if (updateAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.desiredCapacity()));
        }
        if (updateAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.defaultCooldown()));
        }
        if ((availabilityZonesList = updateAutoScalingGroupRequest.availabilityZones()) != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue != null) {
                        request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        if (updateAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)updateAutoScalingGroupRequest.healthCheckType()));
        }
        if (updateAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.healthCheckGracePeriod()));
        }
        if (updateAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)updateAutoScalingGroupRequest.placementGroup()));
        }
        if (updateAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)updateAutoScalingGroupRequest.vpcZoneIdentifier()));
        }
        if ((terminationPoliciesList = updateAutoScalingGroupRequest.terminationPolicies()) != null) {
            if (!terminationPoliciesList.isEmpty()) {
                int terminationPoliciesListIndex = 1;
                for (String terminationPoliciesListValue : terminationPoliciesList) {
                    if (terminationPoliciesListValue != null) {
                        request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringUtils.fromString((String)terminationPoliciesListValue));
                    }
                    ++terminationPoliciesListIndex;
                }
            } else {
                request.addParameter("TerminationPolicies", "");
            }
        }
        if (updateAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)updateAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }
        return request;
    }
}

