/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.ProcessNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SuspendProcessesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SuspendProcessesRequest> {
    private final String autoScalingGroupName;
    private final List<String> scalingProcesses;

    private SuspendProcessesRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> scalingProcesses() {
        return this.scalingProcesses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.scalingProcesses() == null ? 0 : this.scalingProcesses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.scalingProcesses() == null ^ this.scalingProcesses() == null) {
            return false;
        }
        return other.scalingProcesses() == null || other.scalingProcesses().equals(this.scalingProcesses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.scalingProcesses() != null) {
            sb.append("ScalingProcesses: ").append(this.scalingProcesses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scalingProcesses;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendProcessesRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setScalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScalingProcesses() {
            return this.scalingProcesses;
        }

        @Override
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingProcesses(String ... scalingProcesses) {
            this.scalingProcesses(Arrays.asList(scalingProcesses));
            return this;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @SafeVarargs
        public final void setScalingProcesses(String ... scalingProcesses) {
            this.scalingProcesses(Arrays.asList(scalingProcesses));
        }

        public SuspendProcessesRequest build() {
            return new SuspendProcessesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SuspendProcessesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scalingProcesses(Collection<String> var1);

        public Builder scalingProcesses(String ... var1);
    }
}

