/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum LifecycleState {
    Pending("Pending"),
    PendingWait("Pending:Wait"),
    PendingProceed("Pending:Proceed"),
    Quarantined("Quarantined"),
    InService("InService"),
    Terminating("Terminating"),
    TerminatingWait("Terminating:Wait"),
    TerminatingProceed("Terminating:Proceed"),
    Terminated("Terminated"),
    Detaching("Detaching"),
    Detached("Detached"),
    EnteringStandby("EnteringStandby"),
    Standby("Standby");

    private final String value;

    private LifecycleState(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static LifecycleState fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(LifecycleState.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

