/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachLoadBalancersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetachLoadBalancersRequest> {
    private final String autoScalingGroupName;
    private final List<String> loadBalancerNames;

    private DetachLoadBalancersRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.loadBalancerNames = builder.loadBalancerNames;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerNames() == null ? 0 : this.loadBalancerNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachLoadBalancersRequest)) {
            return false;
        }
        DetachLoadBalancersRequest other = (DetachLoadBalancersRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.loadBalancerNames() == null ^ this.loadBalancerNames() == null) {
            return false;
        }
        return other.loadBalancerNames() == null || other.loadBalancerNames().equals(this.loadBalancerNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.loadBalancerNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> loadBalancerNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachLoadBalancersRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setLoadBalancerNames(model.loadBalancerNames);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @SafeVarargs
        public final void setLoadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
        }

        public DetachLoadBalancersRequest build() {
            return new DetachLoadBalancersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetachLoadBalancersRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);
    }
}

