/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfigurationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLaunchConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
    private final List<LaunchConfiguration> launchConfigurations;
    private final String nextToken;

    private DescribeLaunchConfigurationsResponse(BuilderImpl builder) {
        this.launchConfigurations = builder.launchConfigurations;
        this.nextToken = builder.nextToken;
    }

    public List<LaunchConfiguration> launchConfigurations() {
        return this.launchConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.launchConfigurations() == null ? 0 : this.launchConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsResponse)) {
            return false;
        }
        DescribeLaunchConfigurationsResponse other = (DescribeLaunchConfigurationsResponse)((Object)obj);
        if (other.launchConfigurations() == null ^ this.launchConfigurations() == null) {
            return false;
        }
        if (other.launchConfigurations() != null && !other.launchConfigurations().equals(this.launchConfigurations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.launchConfigurations() != null) {
            sb.append("LaunchConfigurations: ").append(this.launchConfigurations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LaunchConfiguration> launchConfigurations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsResponse model) {
            this.setLaunchConfigurations(model.launchConfigurations);
            this.setNextToken(model.nextToken);
        }

        public final Collection<LaunchConfiguration> getLaunchConfigurations() {
            return this.launchConfigurations;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration ... launchConfigurations) {
            this.launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
        }

        @SafeVarargs
        public final void setLaunchConfigurations(LaunchConfiguration ... launchConfigurations) {
            this.launchConfigurations(Arrays.asList(launchConfigurations));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeLaunchConfigurationsResponse build() {
            return new DescribeLaunchConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
        public Builder launchConfigurations(Collection<LaunchConfiguration> var1);

        public Builder launchConfigurations(LaunchConfiguration ... var1);

        public Builder nextToken(String var1);
    }
}

