/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;

public class DescribeNotificationConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeNotificationConfigurationsRequest>, DescribeNotificationConfigurationsRequest> {
    public Request<DescribeNotificationConfigurationsRequest> marshall(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        if (describeNotificationConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeNotificationConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeNotificationConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> autoScalingGroupNamesList = describeNotificationConfigurationsRequest.autoScalingGroupNames();
        if (autoScalingGroupNamesList != null) {
            if (!autoScalingGroupNamesList.isEmpty()) {
                int autoScalingGroupNamesListIndex = 1;
                for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                    if (autoScalingGroupNamesListValue != null) {
                        request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringUtils.fromString((String)autoScalingGroupNamesListValue));
                    }
                    ++autoScalingGroupNamesListIndex;
                }
            } else {
                request.addParameter("AutoScalingGroupNames", "");
            }
        }
        if (describeNotificationConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNotificationConfigurationsRequest.nextToken()));
        }
        if (describeNotificationConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeNotificationConfigurationsRequest.maxRecords()));
        }
        return request;
    }
}

