/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;

public class DescribeAutoScalingInstancesRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingInstancesRequest>, DescribeAutoScalingInstancesRequest> {
    public Request<DescribeAutoScalingInstancesRequest> marshall(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        if (describeAutoScalingInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeAutoScalingInstancesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeAutoScalingInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> instanceIdsList = describeAutoScalingInstancesRequest.instanceIds();
        if (instanceIdsList != null) {
            if (!instanceIdsList.isEmpty()) {
                int instanceIdsListIndex = 1;
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue != null) {
                        request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            } else {
                request.addParameter("InstanceIds", "");
            }
        }
        if (describeAutoScalingInstancesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAutoScalingInstancesRequest.maxRecords()));
        }
        if (describeAutoScalingInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAutoScalingInstancesRequest.nextToken()));
        }
        return request;
    }
}

