/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.Activity;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;

public class DescribeScalingActivitiesIterable
implements SdkIterable<DescribeScalingActivitiesResponse> {
    private final AutoScalingClient client;
    private final DescribeScalingActivitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScalingActivitiesIterable(AutoScalingClient client, DescribeScalingActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScalingActivitiesResponseFetcher();
    }

    public Iterator<DescribeScalingActivitiesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Activity> activities() {
        Function<DescribeScalingActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.activities() != null) {
                return response.activities().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeScalingActivitiesIterable resume(DescribeScalingActivitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeScalingActivitiesIterable(this.client, (DescribeScalingActivitiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeScalingActivitiesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeScalingActivitiesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeScalingActivitiesResponseFetcher
    implements SyncPageFetcher<DescribeScalingActivitiesResponse> {
        private DescribeScalingActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalingActivitiesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeScalingActivitiesResponse nextPage(DescribeScalingActivitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalingActivitiesIterable.this.client.describeScalingActivities(DescribeScalingActivitiesIterable.this.firstRequest);
            }
            return DescribeScalingActivitiesIterable.this.client.describeScalingActivities((DescribeScalingActivitiesRequest)((Object)DescribeScalingActivitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

