/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAutoScalingGroupRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, UpdateAutoScalingGroupRequest> {
    private final String autoScalingGroupName;
    private final String launchConfigurationName;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;

    private UpdateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String healthCheckType() {
        return this.healthCheckType;
    }

    public Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.newInstancesProtectedFromScaleIn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutoScalingGroupRequest)) {
            return false;
        }
        UpdateAutoScalingGroupRequest other = (UpdateAutoScalingGroupRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.defaultCooldown(), other.defaultCooldown()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.vpcZoneIdentifier(), other.vpcZoneIdentifier()) && Objects.equals(this.terminationPolicies(), other.terminationPolicies()) && Objects.equals(this.newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAutoScalingGroupRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("DefaultCooldown", (Object)this.defaultCooldown()).add("AvailabilityZones", this.availabilityZones()).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("PlacementGroup", (Object)this.placementGroup()).add("VPCZoneIdentifier", (Object)this.vpcZoneIdentifier()).add("TerminationPolicies", this.terminationPolicies()).add("NewInstancesProtectedFromScaleIn", (Object)this.newInstancesProtectedFromScaleIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "LaunchConfigurationName": {
                return Optional.of(clazz.cast(this.launchConfigurationName()));
            }
            case "MinSize": {
                return Optional.of(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.of(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.of(clazz.cast(this.desiredCapacity()));
            }
            case "DefaultCooldown": {
                return Optional.of(clazz.cast(this.defaultCooldown()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "HealthCheckType": {
                return Optional.of(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.of(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "PlacementGroup": {
                return Optional.of(clazz.cast(this.placementGroup()));
            }
            case "VPCZoneIdentifier": {
                return Optional.of(clazz.cast(this.vpcZoneIdentifier()));
            }
            case "TerminationPolicies": {
                return Optional.of(clazz.cast(this.terminationPolicies()));
            }
            case "NewInstancesProtectedFromScaleIn": {
                return Optional.of(clazz.cast(this.newInstancesProtectedFromScaleIn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String launchConfigurationName;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones;
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<String> terminationPolicies;
        private Boolean newInstancesProtectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutoScalingGroupRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.launchConfigurationName(model.launchConfigurationName);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
            this.defaultCooldown(model.defaultCooldown);
            this.availabilityZones(model.availabilityZones);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.placementGroup(model.placementGroup);
            this.vpcZoneIdentifier(model.vpcZoneIdentifier);
            this.terminationPolicies(model.terminationPolicies);
            this.newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            this.terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutoScalingGroupRequest build() {
            return new UpdateAutoScalingGroupRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, UpdateAutoScalingGroupRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

