/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetInstanceHealthRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, SetInstanceHealthRequest> {
    private final String instanceId;
    private final String healthStatus;
    private final Boolean shouldRespectGracePeriod;

    private SetInstanceHealthRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.shouldRespectGracePeriod = builder.shouldRespectGracePeriod;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public Boolean shouldRespectGracePeriod() {
        return this.shouldRespectGracePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.shouldRespectGracePeriod());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetInstanceHealthRequest)) {
            return false;
        }
        SetInstanceHealthRequest other = (SetInstanceHealthRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.healthStatus(), other.healthStatus()) && Objects.equals(this.shouldRespectGracePeriod(), other.shouldRespectGracePeriod());
    }

    public String toString() {
        return ToString.builder((String)"SetInstanceHealthRequest").add("InstanceId", (Object)this.instanceId()).add("HealthStatus", (Object)this.healthStatus()).add("ShouldRespectGracePeriod", (Object)this.shouldRespectGracePeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "HealthStatus": {
                return Optional.of(clazz.cast(this.healthStatus()));
            }
            case "ShouldRespectGracePeriod": {
                return Optional.of(clazz.cast(this.shouldRespectGracePeriod()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String healthStatus;
        private Boolean shouldRespectGracePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SetInstanceHealthRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.healthStatus(model.healthStatus);
            this.shouldRespectGracePeriod(model.shouldRespectGracePeriod);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Boolean getShouldRespectGracePeriod() {
            return this.shouldRespectGracePeriod;
        }

        @Override
        public final Builder shouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
            return this;
        }

        public final void setShouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetInstanceHealthRequest build() {
            return new SetInstanceHealthRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, SetInstanceHealthRequest> {
        public Builder instanceId(String var1);

        public Builder healthStatus(String var1);

        public Builder shouldRespectGracePeriod(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

