/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
@SdkPublicApi
public final class AwsBasicCredentials
implements AwsCredentials,
ToCopyableBuilder<Builder, AwsBasicCredentials> {
    @SdkInternalApi
    static final AwsBasicCredentials ANONYMOUS_CREDENTIALS = AwsBasicCredentials.builder().validateCredentials(false).build();
    private final String accessKeyId;
    private final String secretAccessKey;
    private final boolean validateCredentials;
    private final String providerName;

    private AwsBasicCredentials(Builder builder) {
        this.accessKeyId = StringUtils.trimToNull((String)builder.accessKeyId);
        this.secretAccessKey = StringUtils.trimToNull((String)builder.secretAccessKey);
        this.validateCredentials = builder.validateCredentials;
        this.providerName = builder.providerName;
        if (builder.validateCredentials) {
            Validate.notNull((Object)this.accessKeyId, (String)"Access key ID cannot be blank.", (Object[])new Object[0]);
            Validate.notNull((Object)this.secretAccessKey, (String)"Secret access key cannot be blank.", (Object[])new Object[0]);
        }
    }

    protected AwsBasicCredentials(String accessKeyId, String secretAccessKey) {
        this.accessKeyId = StringUtils.trimToNull((String)accessKeyId);
        this.secretAccessKey = StringUtils.trimToNull((String)secretAccessKey);
        this.validateCredentials = false;
        this.providerName = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AwsBasicCredentials create(String accessKeyId, String secretAccessKey) {
        return AwsBasicCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretAccessKey).build();
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public Optional<String> providerName() {
        return Optional.ofNullable(this.providerName);
    }

    public String toString() {
        return ToString.builder((String)"AwsCredentials").add("accessKeyId", (Object)this.accessKeyId).add("providerName", (Object)this.providerName).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsBasicCredentials that = (AwsBasicCredentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        return hashCode;
    }

    public Builder toBuilder() {
        return AwsBasicCredentials.builder().accessKeyId(this.accessKeyId).secretAccessKey(this.secretAccessKey).validateCredentials(this.validateCredentials).providerName(this.providerName);
    }

    public AwsBasicCredentials copy(Consumer<? super Builder> modifier) {
        return (AwsBasicCredentials)super.copy(modifier);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, AwsBasicCredentials> {
        private String accessKeyId;
        private String secretAccessKey;
        private String providerName;
        private boolean validateCredentials = true;

        private Builder() {
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @SdkInternalApi
        public Builder validateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
            return this;
        }

        public AwsBasicCredentials build() {
            return new AwsBasicCredentials(this);
        }
    }
}

