/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.token.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.ChildProfileTokenProviderFactory;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.core.internal.util.ClassLoaderHelper;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.internal.ProfileSection;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ProfileTokenProviderLoader {
    private static final String SSO_OIDC_TOKEN_PROVIDER_FACTORY = "software.amazon.awssdk.services.ssooidc.SsoOidcProfileTokenProviderFactory";
    private final Profile profile;
    private final ProfileFile profileFile;

    public ProfileTokenProviderLoader(ProfileFile profileFile, Profile profile) {
        this.profile = (Profile)Validate.paramNotNull((Object)profile, (String)"profile");
        this.profileFile = (ProfileFile)Validate.paramNotNull((Object)profileFile, (String)"profileFile");
    }

    public Optional<SdkTokenProvider> tokenProvider() {
        return Optional.ofNullable(this.ssoProfileCredentialsProvider());
    }

    private SdkTokenProvider ssoProfileCredentialsProvider() {
        String profileSsoSectionName = (String)this.profile.property(ProfileSection.SSO_SESSION.getPropertyKeyName()).orElseThrow(() -> new IllegalArgumentException("Profile " + this.profile.name() + " does not have sso_session property"));
        Profile ssoProfile = (Profile)this.profileFile.getSection(ProfileSection.SSO_SESSION.getSectionTitle(), profileSsoSectionName).orElseThrow(() -> new IllegalArgumentException("Sso-session section not found with sso-session title " + profileSsoSectionName));
        this.validateRequiredProperties(ssoProfile, "sso_region", "sso_start_url");
        return this.ssoTokenProviderFactory().create(this.profileFile, this.profile);
    }

    private void validateRequiredProperties(Profile ssoProfile, String ... requiredProperties) {
        Arrays.stream(requiredProperties).forEach(p -> Validate.isTrue((boolean)ssoProfile.properties().containsKey(p), (String)"Property '%s' was not configured for profile '%s'.", (Object[])new Object[]{p, this.profile.name()}));
    }

    private ChildProfileTokenProviderFactory ssoTokenProviderFactory() {
        try {
            Class ssoOidcTokenProviderFactory = ClassLoaderHelper.loadClass((String)SSO_OIDC_TOKEN_PROVIDER_FACTORY, (Class[])new Class[]{this.getClass()});
            return (ChildProfileTokenProviderFactory)ssoOidcTokenProviderFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("To use SSO OIDC related properties in the '" + this.profile.name() + "' profile, the 'ssooidc' service module must be on the class path.", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create the '" + this.profile.name() + "' token provider factory.", e);
        }
    }
}

