/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.net.URI;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.internal.HttpCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.internal.util.HttpResourcesUtils;
import software.amazon.awssdk.regions.internal.util.ResourcesEndpointProvider;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public final class InstanceProfileCredentialsProvider
extends HttpCredentialsProvider {
    private static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    private final ResourcesEndpointProvider credentialsEndpointProvider = new InstanceProviderCredentialsEndpointProvider();

    private InstanceProfileCredentialsProvider(BuilderImpl builder) {
        super(builder);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static InstanceProfileCredentialsProvider create() {
        return InstanceProfileCredentialsProvider.builder().build();
    }

    @Override
    protected ResourcesEndpointProvider getCredentialsEndpointProvider() {
        return this.credentialsEndpointProvider;
    }

    @Override
    protected boolean isLocalCredentialLoadingDisabled() {
        return SdkSystemSetting.AWS_EC2_METADATA_DISABLED.getBooleanValueOrThrow();
    }

    public String toString() {
        return ToString.create((String)"InstanceProfileCredentialsProvider");
    }

    private static final class BuilderImpl
    extends HttpCredentialsProvider.BuilderImpl<InstanceProfileCredentialsProvider, Builder>
    implements Builder {
        private BuilderImpl() {
            super.asyncThreadName("instance-profile-credentials-provider");
        }

        @Override
        public InstanceProfileCredentialsProvider build() {
            return new InstanceProfileCredentialsProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialsProvider.Builder<InstanceProfileCredentialsProvider, Builder> {
        @Override
        public InstanceProfileCredentialsProvider build();
    }

    private static final class InstanceProviderCredentialsEndpointProvider
    implements ResourcesEndpointProvider {
        private InstanceProviderCredentialsEndpointProvider() {
        }

        public URI endpoint() throws IOException {
            String host = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getStringValueOrThrow();
            URI endpoint = URI.create(host + InstanceProfileCredentialsProvider.SECURITY_CREDENTIALS_RESOURCE);
            String securityCredentialsList = HttpResourcesUtils.instance().readResource(endpoint);
            String[] securityCredentials = securityCredentialsList.trim().split("\n");
            if (securityCredentials.length == 0) {
                throw SdkClientException.builder().message("Unable to load credentials path").build();
            }
            return URI.create(host + InstanceProfileCredentialsProvider.SECURITY_CREDENTIALS_RESOURCE + securityCredentials[0]);
        }
    }
}

