/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.HttpCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.util.HttpResourcesUtils;
import software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import software.amazon.awssdk.utils.ToString;

public class InstanceProfileCredentialsProvider
extends HttpCredentialsProvider {
    static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    private final ResourcesEndpointProvider credentialsEndpointProvider = new InstanceProviderCredentialsEndpointProvider();

    private InstanceProfileCredentialsProvider(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InstanceProfileCredentialsProvider create() {
        return InstanceProfileCredentialsProvider.builder().build();
    }

    @Override
    protected ResourcesEndpointProvider getCredentialsEndpointProvider() {
        return this.credentialsEndpointProvider;
    }

    public String toString() {
        return ToString.create((String)"InstanceProfileCredentialsProvider");
    }

    public static final class Builder
    extends HttpCredentialsProvider.Builder<InstanceProfileCredentialsProvider, Builder> {
        private Builder() {
            super.asyncThreadName("instance-profile-credentials-provider");
        }

        @Override
        public InstanceProfileCredentialsProvider build() {
            return new InstanceProfileCredentialsProvider(this);
        }
    }

    private static class InstanceProviderCredentialsEndpointProvider
    implements ResourcesEndpointProvider {
        private InstanceProviderCredentialsEndpointProvider() {
        }

        public URI endpoint() throws IOException {
            String host = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getStringValueOrThrow();
            URI endpoint = URI.create(host + InstanceProfileCredentialsProvider.SECURITY_CREDENTIALS_RESOURCE);
            String securityCredentialsList = HttpResourcesUtils.instance().readResource(endpoint);
            String[] securityCredentials = securityCredentialsList.trim().split("\n");
            if (securityCredentials.length == 0) {
                throw new SdkClientException("Unable to load credentials path");
            }
            return URI.create(host + InstanceProfileCredentialsProvider.SECURITY_CREDENTIALS_RESOURCE + securityCredentials[0]);
        }
    }
}

