/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.authcrt.signer.internal.SdkSigningResult;
import software.amazon.awssdk.crt.auth.signing.AwsSigningResult;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class CrtHttpRequestConverter {
    private static final String SLASH = "/";
    private static final String HOST_HEADER = "Host";
    private static final int READ_BUFFER_SIZE = 4096;

    public HttpRequest requestToCrt(SdkHttpFullRequest inputRequest) {
        String method = inputRequest.method().name();
        String encodedPath = CrtHttpRequestConverter.encodedPathToCrtFormat(inputRequest.encodedPath());
        String encodedQueryString = inputRequest.encodedQueryParameters().map(value -> "?" + value).orElse("");
        HttpHeader[] crtHeaderArray = this.createHttpHeaderArray(inputRequest);
        Optional contentProvider = inputRequest.contentStreamProvider();
        CrtInputStream crtInputStream = null;
        if (contentProvider.isPresent()) {
            crtInputStream = new CrtInputStream((ContentStreamProvider)contentProvider.get());
        }
        return new HttpRequest(method, encodedPath + encodedQueryString, crtHeaderArray, (HttpRequestBodyStream)crtInputStream);
    }

    public SdkHttpFullRequest crtRequestToHttp(SdkHttpFullRequest inputRequest, HttpRequest signedCrtRequest) {
        int nextQuery;
        SdkHttpFullRequest.Builder builder = inputRequest.toBuilder();
        builder.clearHeaders();
        for (HttpHeader header : signedCrtRequest.getHeaders()) {
            builder.appendHeader(header.getName(), header.getValue());
        }
        URI fullUri = null;
        try {
            String portString = SdkHttpUtils.isUsingStandardPort((String)builder.protocol(), (Integer)builder.port()) ? "" : ":" + builder.port();
            String encodedPath = CrtHttpRequestConverter.encodedPathFromCrtFormat(inputRequest.encodedPath(), signedCrtRequest.getEncodedPath());
            String fullUriString = builder.protocol() + "://" + builder.host() + portString + encodedPath;
            fullUri = new URI(fullUriString);
        }
        catch (URISyntaxException e) {
            return null;
        }
        builder.encodedPath(fullUri.getRawPath());
        builder.clearQueryParameters();
        for (String remainingQuery = fullUri.getRawQuery(); remainingQuery != null && remainingQuery.length() > 0; remainingQuery = remainingQuery.substring(nextQuery + 1)) {
            String queryName;
            nextQuery = remainingQuery.indexOf(38);
            int nextAssign = remainingQuery.indexOf(61);
            if (nextAssign < nextQuery || nextAssign >= 0 && nextQuery < 0) {
                queryName = remainingQuery.substring(0, nextAssign);
                String queryValue = remainingQuery.substring(nextAssign + 1);
                if (nextQuery >= 0) {
                    queryValue = remainingQuery.substring(nextAssign + 1, nextQuery);
                }
                builder.appendRawQueryParameter(SdkHttpUtils.urlDecode((String)queryName), SdkHttpUtils.urlDecode((String)queryValue));
            } else {
                queryName = remainingQuery;
                if (nextQuery >= 0) {
                    queryName = remainingQuery.substring(0, nextQuery);
                }
                builder.appendRawQueryParameter(SdkHttpUtils.urlDecode((String)queryName), null);
            }
            if (nextQuery < 0) break;
        }
        return builder.build();
    }

    public SdkSigningResult crtResultToAws(SdkHttpFullRequest originalRequest, AwsSigningResult signingResult) {
        SdkHttpFullRequest sdkHttpFullRequest = this.crtRequestToHttp(originalRequest, signingResult.getSignedRequest());
        return new SdkSigningResult(signingResult.getSignature(), sdkHttpFullRequest);
    }

    public HttpRequestBodyStream toCrtStream(byte[] data) {
        return new CrtByteArrayInputStream(data);
    }

    private HttpHeader[] createHttpHeaderArray(SdkHttpFullRequest request) {
        ArrayList<HttpHeader> crtHeaderList = new ArrayList<HttpHeader>(request.numHeaders() + 2);
        if (!request.firstMatchingHeader(HOST_HEADER).isPresent()) {
            crtHeaderList.add(new HttpHeader(HOST_HEADER, request.host()));
        }
        request.forEachHeader((name, values) -> {
            for (String val : values) {
                HttpHeader h = new HttpHeader(name, val);
                crtHeaderList.add(h);
            }
        });
        return crtHeaderList.toArray(new HttpHeader[0]);
    }

    private static String encodedPathToCrtFormat(String sdkEncodedPath) {
        if (StringUtils.isEmpty((CharSequence)sdkEncodedPath)) {
            return SLASH;
        }
        return sdkEncodedPath;
    }

    private static String encodedPathFromCrtFormat(String sdkEncodedPath, String crtEncodedPath) {
        if (SLASH.equals(crtEncodedPath) && StringUtils.isEmpty((CharSequence)sdkEncodedPath)) {
            return "";
        }
        return crtEncodedPath;
    }

    private static class CrtInputStream
    implements HttpRequestBodyStream {
        private ContentStreamProvider provider;
        private InputStream providerStream;
        private byte[] readBuffer;

        CrtInputStream(ContentStreamProvider provider) {
            this.provider = provider;
            this.readBuffer = new byte[4096];
        }

        public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
            int read = 0;
            try {
                int toRead;
                if (this.providerStream == null) {
                    this.createNewStream();
                }
                if ((read = this.providerStream.read(this.readBuffer, 0, toRead = Math.min(4096, bodyBytesOut.remaining()))) > 0) {
                    bodyBytesOut.put(this.readBuffer, 0, read);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return read < 0;
        }

        public boolean resetPosition() {
            if (this.provider == null) {
                throw new IllegalStateException("Cannot reset position while provider is null");
            }
            try {
                this.createNewStream();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return true;
        }

        private void createNewStream() throws IOException {
            if (this.provider == null) {
                throw new IllegalStateException("Cannot create a new stream while provider is null");
            }
            if (this.providerStream != null) {
                this.providerStream.close();
            }
            this.providerStream = this.provider.newStream();
        }
    }

    private static class CrtByteArrayInputStream
    implements HttpRequestBodyStream {
        private byte[] data;
        private byte[] readBuffer;
        private ByteArrayInputStream providerStream;

        CrtByteArrayInputStream(byte[] data) {
            this.data = data;
            this.readBuffer = new byte[4096];
        }

        public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
            int read = 0;
            try {
                int toRead;
                if (this.providerStream == null) {
                    this.createNewStream();
                }
                if ((read = this.providerStream.read(this.readBuffer, 0, toRead = Math.min(4096, bodyBytesOut.remaining()))) > 0) {
                    bodyBytesOut.put(this.readBuffer, 0, read);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return read < 0;
        }

        public boolean resetPosition() {
            try {
                this.createNewStream();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return true;
        }

        private void createNewStream() throws IOException {
            if (this.providerStream != null) {
                this.providerStream.close();
            }
            this.providerStream = new ByteArrayInputStream(this.data);
        }
    }
}

