/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.authcrt.signer.AwsCrtV4aSigner;
import software.amazon.awssdk.authcrt.signer.internal.AwsCrt4aSigningAdapter;
import software.amazon.awssdk.authcrt.signer.internal.SigningConfigProvider;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkInternalApi
public final class DefaultAwsCrtV4aSigner
implements AwsCrtV4aSigner {
    private final AwsCrt4aSigningAdapter signer = new AwsCrt4aSigningAdapter();
    private final SigningConfigProvider configProvider = new SigningConfigProvider();

    private DefaultAwsCrtV4aSigner() {
    }

    public static AwsCrtV4aSigner create() {
        return new DefaultAwsCrtV4aSigner();
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (CredentialUtils.isAnonymous((AwsCredentials)((AwsCredentials)executionAttributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS)))) {
            return request;
        }
        return this.signer.signRequest(request, this.configProvider.createCrtSigningConfig(executionAttributes));
    }

    public SdkHttpFullRequest presign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        return this.signer.signRequest(request, this.configProvider.createCrtPresigningConfig(executionAttributes));
    }
}

