/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.S3SignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerUtils;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkSigner;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsSignedChunkedEncodingInputStream;
import software.amazon.awssdk.auth.signer.params.SignerChecksumParams;
import software.amazon.awssdk.authcrt.signer.AwsCrtS3V4aSigner;
import software.amazon.awssdk.authcrt.signer.internal.AwsCrt4aSigningAdapter;
import software.amazon.awssdk.authcrt.signer.internal.SdkSigningResult;
import software.amazon.awssdk.authcrt.signer.internal.SigningConfigProvider;
import software.amazon.awssdk.authcrt.signer.internal.chunkedencoding.AwsS3V4aChunkSigner;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.core.checksums.ChecksumSpecs;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.internal.chunked.AwsChunkedEncodingConfig;
import software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.regions.RegionScope;

@SdkInternalApi
public final class DefaultAwsCrtS3V4aSigner
implements AwsCrtS3V4aSigner {
    private final AwsCrt4aSigningAdapter signerAdapter;
    private final SigningConfigProvider configProvider;
    private final RegionScope defaultRegionScope;

    DefaultAwsCrtS3V4aSigner(AwsCrt4aSigningAdapter signerAdapter, SigningConfigProvider signingConfigProvider) {
        this(signerAdapter, signingConfigProvider, null);
    }

    DefaultAwsCrtS3V4aSigner(AwsCrt4aSigningAdapter signerAdapter, SigningConfigProvider signingConfigProvider, RegionScope defaultRegionScope) {
        this.signerAdapter = signerAdapter;
        this.configProvider = signingConfigProvider;
        this.defaultRegionScope = defaultRegionScope;
    }

    private DefaultAwsCrtS3V4aSigner(BuilderImpl builder) {
        this(new AwsCrt4aSigningAdapter(), new SigningConfigProvider(), builder.defaultRegionScope);
    }

    public static AwsCrtS3V4aSigner create() {
        return DefaultAwsCrtS3V4aSigner.builder().build();
    }

    public static AwsCrtS3V4aSigner.Builder builder() {
        return new BuilderImpl();
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (this.credentialsAreAnonymous(executionAttributes)) {
            return request;
        }
        ExecutionAttributes defaultsApplied = this.applyDefaults(executionAttributes);
        AwsSigningConfig requestSigningConfig = this.configProvider.createS3CrtSigningConfig(defaultsApplied);
        SignerChecksumParams signerChecksumParams = DefaultAwsCrtS3V4aSigner.signerChecksumParamsFromAttributes(defaultsApplied);
        if (this.shouldSignPayload(request, defaultsApplied)) {
            SdkHttpFullRequest.Builder mutableRequest = request.toBuilder();
            if (signerChecksumParams != null) {
                requestSigningConfig.setSignedBodyValue("STREAMING-AWS4-ECDSA-P256-SHA256-PAYLOAD-TRAILER");
                DefaultAwsCrtS3V4aSigner.updateRequestWithTrailer(signerChecksumParams, mutableRequest);
            } else {
                requestSigningConfig.setSignedBodyValue("STREAMING-AWS4-ECDSA-P256-SHA256-PAYLOAD");
            }
            this.setHeaderContentLength(mutableRequest, signerChecksumParams);
            SdkSigningResult signingResult = this.signerAdapter.sign(mutableRequest.build(), requestSigningConfig);
            AwsSigningConfig chunkConfig = this.configProvider.createChunkedSigningConfig(defaultsApplied);
            return this.enablePayloadSigning(signingResult, chunkConfig, signerChecksumParams);
        }
        requestSigningConfig.setSignedBodyValue(signerChecksumParams != null ? "STREAMING-UNSIGNED-PAYLOAD-TRAILER" : "UNSIGNED-PAYLOAD");
        return this.signerAdapter.signRequest(request, requestSigningConfig);
    }

    private static SignerChecksumParams signerChecksumParamsFromAttributes(ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm((ExecutionAttributes)executionAttributes).orElse(null);
        if (checksumSpecs == null) {
            return null;
        }
        return SignerChecksumParams.builder().isStreamingRequest(checksumSpecs.isRequestStreaming()).algorithm(checksumSpecs.algorithm()).checksumHeaderName(checksumSpecs.headerName()).build();
    }

    public SdkHttpFullRequest presign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (this.credentialsAreAnonymous(executionAttributes)) {
            return request;
        }
        ExecutionAttributes defaultsApplied = this.applyDefaults(executionAttributes);
        return this.signerAdapter.signRequest(request, this.configProvider.createS3CrtPresigningConfig(defaultsApplied));
    }

    private boolean credentialsAreAnonymous(ExecutionAttributes executionAttributes) {
        return CredentialUtils.isAnonymous((AwsCredentials)((AwsCredentials)executionAttributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS)));
    }

    private boolean shouldSignPayload(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (!request.protocol().equals("https") && request.contentStreamProvider().isPresent()) {
            return true;
        }
        boolean payloadSigning = this.booleanValue((Boolean)executionAttributes.getAttribute(S3SignerExecutionAttribute.ENABLE_PAYLOAD_SIGNING));
        boolean chunkedEncoding = this.booleanValue((Boolean)executionAttributes.getAttribute(S3SignerExecutionAttribute.ENABLE_CHUNKED_ENCODING));
        return payloadSigning && chunkedEncoding;
    }

    private void setHeaderContentLength(SdkHttpFullRequest.Builder mutableRequest, SignerChecksumParams signerChecksumParams) {
        long originalContentLength = Aws4SignerUtils.calculateRequestContentLength((SdkHttpFullRequest.Builder)mutableRequest);
        mutableRequest.putHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
        String totalLength = Long.toString(AwsSignedChunkedEncodingInputStream.calculateStreamContentLength((long)originalContentLength, (int)AwsS3V4aChunkSigner.getSignatureLength(), (AwsChunkedEncodingConfig)AwsChunkedEncodingConfig.create(), (signerChecksumParams != null ? 1 : 0) != 0) + DefaultAwsCrtS3V4aSigner.getChecksumTrailerLength(signerChecksumParams, AwsS3V4aChunkSigner.getSignatureLength()));
        mutableRequest.putHeader("Content-Length", totalLength);
    }

    private SdkHttpFullRequest enablePayloadSigning(SdkSigningResult signingResult, AwsSigningConfig chunkConfig, SignerChecksumParams signerChecksumParams) {
        SdkHttpFullRequest signedRequest = signingResult.getSignedRequest();
        byte[] signature = signingResult.getSignature();
        SdkHttpFullRequest.Builder mutableSignedRequest = signedRequest.toBuilder();
        ContentStreamProvider streamProvider = mutableSignedRequest.contentStreamProvider();
        AwsS3V4aChunkSigner chunkSigner = new AwsS3V4aChunkSigner(this.signerAdapter, chunkConfig);
        String checksumHeader = signerChecksumParams != null ? signerChecksumParams.checksumHeaderName() : null;
        SdkChecksum sdkChecksum = signerChecksumParams != null ? SdkChecksum.forAlgorithm((Algorithm)signerChecksumParams.algorithm()) : null;
        mutableSignedRequest.contentStreamProvider(() -> ((AwsSignedChunkedEncodingInputStream.Builder)((AwsSignedChunkedEncodingInputStream.Builder)((AwsSignedChunkedEncodingInputStream.Builder)((AwsSignedChunkedEncodingInputStream.Builder)AwsSignedChunkedEncodingInputStream.builder().inputStream(streamProvider.newStream())).awsChunkSigner((AwsChunkSigner)chunkSigner).checksumHeaderForTrailer(checksumHeader)).sdkChecksum(sdkChecksum)).headerSignature(new String(signature, StandardCharsets.UTF_8)).awsChunkedEncodingConfig(AwsChunkedEncodingConfig.create())).build());
        return mutableSignedRequest.build();
    }

    private boolean booleanValue(Boolean attribute) {
        return Boolean.TRUE.equals(attribute);
    }

    private ExecutionAttributes applyDefaults(ExecutionAttributes executionAttributes) {
        return this.applyDefaultRegionScope(executionAttributes);
    }

    private ExecutionAttributes applyDefaultRegionScope(ExecutionAttributes executionAttributes) {
        if (executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE) != null) {
            return executionAttributes;
        }
        if (this.defaultRegionScope == null) {
            return executionAttributes;
        }
        return executionAttributes.copy().putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE, (Object)this.defaultRegionScope);
    }

    private static long getChecksumTrailerLength(SignerChecksumParams signerParams, int signatureLength) {
        return signerParams == null ? 0L : (long)AwsSignedChunkedEncodingInputStream.calculateChecksumContentLength((Algorithm)signerParams.algorithm(), (String)signerParams.checksumHeaderName(), (int)signatureLength);
    }

    private static void updateRequestWithTrailer(SignerChecksumParams signerChecksumParams, SdkHttpFullRequest.Builder mutableRequest) {
        mutableRequest.putHeader("x-amz-trailer", signerChecksumParams.checksumHeaderName());
        mutableRequest.putHeader("Content-Encoding", "aws-chunked");
    }

    private static class BuilderImpl
    implements AwsCrtS3V4aSigner.Builder {
        private RegionScope defaultRegionScope;

        private BuilderImpl() {
        }

        @Override
        public AwsCrtS3V4aSigner.Builder defaultRegionScope(RegionScope defaultRegionScope) {
            this.defaultRegionScope = defaultRegionScope;
            return this;
        }

        @Override
        public AwsCrtS3V4aSigner build() {
            return new DefaultAwsCrtS3V4aSigner(this);
        }
    }
}

